/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHBranchProtection;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranchProtectionBuilder {
    private final GHBranch branch;
    private Map<String, Object> fields = new HashMap<String, Object>();
    private Map<String, Object> prReviews;
    private Restrictions restrictions;
    private StatusChecks statusChecks;

    GHBranchProtectionBuilder(GHBranch branch) {
        this.branch = branch;
        this.includeAdmins(false);
    }

    public GHBranchProtectionBuilder addRequiredStatusChecks(Collection<GHBranchProtection.Check> checks) {
        this.getStatusChecks().checks.addAll(checks);
        return this;
    }

    @Deprecated
    public GHBranchProtectionBuilder addRequiredChecks(Collection<String> checks) {
        this.getStatusChecks().checks.addAll(checks.stream().map(context -> new GHBranchProtection.Check((String)context, null)).collect(Collectors.toList()));
        return this;
    }

    @Deprecated
    public GHBranchProtectionBuilder addRequiredChecks(String ... checks) {
        this.addRequiredChecks(Arrays.asList(checks));
        return this;
    }

    public GHBranchProtectionBuilder addRequiredChecks(GHBranchProtection.Check ... checks) {
        this.addRequiredStatusChecks(Arrays.asList(checks));
        return this;
    }

    public GHBranchProtectionBuilder allowDeletions() {
        return this.allowDeletions(true);
    }

    public GHBranchProtectionBuilder allowDeletions(boolean v) {
        this.fields.put("allow_deletions", v);
        return this;
    }

    public GHBranchProtectionBuilder allowForcePushes() {
        return this.allowForcePushes(true);
    }

    public GHBranchProtectionBuilder allowForcePushes(boolean v) {
        this.fields.put("allow_force_pushes", v);
        return this;
    }

    public GHBranchProtectionBuilder allowForkSyncing() {
        return this.allowForkSyncing(true);
    }

    public GHBranchProtectionBuilder allowForkSyncing(boolean v) {
        this.fields.put("allow_fork_syncing", v);
        return this;
    }

    public GHBranchProtectionBuilder blockCreations() {
        return this.blockCreations(true);
    }

    public GHBranchProtectionBuilder blockCreations(boolean v) {
        this.fields.put("block_creations", v);
        return this;
    }

    public GHBranchProtectionBuilder dismissStaleReviews() {
        return this.dismissStaleReviews(true);
    }

    public GHBranchProtectionBuilder dismissStaleReviews(boolean v) {
        this.getPrReviews().put("dismiss_stale_reviews", v);
        return this;
    }

    public GHBranchProtection enable() throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.requester().method("PUT")).with(this.fields)).withNullable("required_status_checks", this.statusChecks)).withNullable("required_pull_request_reviews", this.prReviews)).withNullable("restrictions", this.restrictions)).withUrlPath(this.branch.getProtectionUrl().toString(), new String[0])).fetch(GHBranchProtection.class);
    }

    public GHBranchProtectionBuilder includeAdmins() {
        return this.includeAdmins(true);
    }

    public GHBranchProtectionBuilder includeAdmins(boolean v) {
        this.fields.put("enforce_admins", v);
        return this;
    }

    public GHBranchProtectionBuilder lockBranch() {
        return this.lockBranch(true);
    }

    public GHBranchProtectionBuilder lockBranch(boolean v) {
        this.fields.put("lock_branch", v);
        return this;
    }

    public GHBranchProtectionBuilder requiredReviewers(int v) {
        this.getPrReviews().put("required_approving_review_count", v);
        return this;
    }

    public GHBranchProtectionBuilder requireBranchIsUpToDate() {
        return this.requireBranchIsUpToDate(true);
    }

    public GHBranchProtectionBuilder requireBranchIsUpToDate(boolean v) {
        this.getStatusChecks().strict = v;
        return this;
    }

    public GHBranchProtectionBuilder requireCodeOwnReviews() {
        return this.requireCodeOwnReviews(true);
    }

    public GHBranchProtectionBuilder requireCodeOwnReviews(boolean v) {
        this.getPrReviews().put("require_code_owner_reviews", v);
        return this;
    }

    public GHBranchProtectionBuilder requireLastPushApproval() {
        return this.requireLastPushApproval(true);
    }

    public GHBranchProtectionBuilder requireLastPushApproval(boolean v) {
        this.getPrReviews().put("require_last_push_approval", v);
        return this;
    }

    public GHBranchProtectionBuilder requiredConversationResolution() {
        return this.requiredConversationResolution(true);
    }

    public GHBranchProtectionBuilder requiredConversationResolution(boolean v) {
        this.fields.put("required_conversation_resolution", v);
        return this;
    }

    public GHBranchProtectionBuilder requiredLinearHistory() {
        return this.requiredLinearHistory(true);
    }

    public GHBranchProtectionBuilder requiredLinearHistory(boolean v) {
        this.fields.put("required_linear_history", v);
        return this;
    }

    public GHBranchProtectionBuilder requireReviews() {
        this.getPrReviews();
        return this;
    }

    public GHBranchProtectionBuilder restrictReviewDismissals() {
        this.getPrReviews();
        if (!this.prReviews.containsKey("dismissal_restrictions")) {
            this.prReviews.put("dismissal_restrictions", new Restrictions());
        }
        return this;
    }

    public GHBranchProtectionBuilder restrictPushAccess() {
        this.getRestrictions();
        return this;
    }

    public GHBranchProtectionBuilder teamPushAccess(Collection<GHTeam> teams) {
        for (GHTeam team : teams) {
            this.teamPushAccess(team);
        }
        return this;
    }

    public GHBranchProtectionBuilder teamPushAccess(GHTeam ... teams) {
        for (GHTeam team : teams) {
            this.getRestrictions().teams.add(team.getSlug());
        }
        return this;
    }

    public GHBranchProtectionBuilder teamReviewDismissals(Collection<GHTeam> teams) {
        for (GHTeam team : teams) {
            this.teamReviewDismissals(team);
        }
        return this;
    }

    public GHBranchProtectionBuilder teamReviewDismissals(GHTeam ... teams) {
        for (GHTeam team : teams) {
            this.addReviewRestriction(team.getSlug(), true);
        }
        return this;
    }

    public GHBranchProtectionBuilder userPushAccess(Collection<GHUser> users) {
        for (GHUser user : users) {
            this.userPushAccess(user);
        }
        return this;
    }

    public GHBranchProtectionBuilder userPushAccess(GHUser ... users) {
        for (GHUser user : users) {
            this.getRestrictions().users.add(user.getLogin());
        }
        return this;
    }

    public GHBranchProtectionBuilder userReviewDismissals(Collection<GHUser> users) {
        for (GHUser team : users) {
            this.userReviewDismissals(team);
        }
        return this;
    }

    public GHBranchProtectionBuilder userReviewDismissals(GHUser ... users) {
        for (GHUser user : users) {
            this.addReviewRestriction(user.getLogin(), false);
        }
        return this;
    }

    private void addReviewRestriction(String restriction, boolean isTeam) {
        this.restrictReviewDismissals();
        Restrictions restrictions = (Restrictions)this.prReviews.get("dismissal_restrictions");
        if (isTeam) {
            restrictions.teams.add(restriction);
        } else {
            restrictions.users.add(restriction);
        }
    }

    private Map<String, Object> getPrReviews() {
        if (this.prReviews == null) {
            this.prReviews = new HashMap<String, Object>();
        }
        return this.prReviews;
    }

    private Restrictions getRestrictions() {
        if (this.restrictions == null) {
            this.restrictions = new Restrictions();
        }
        return this.restrictions;
    }

    private StatusChecks getStatusChecks() {
        if (this.statusChecks == null) {
            this.statusChecks = new StatusChecks();
        }
        return this.statusChecks;
    }

    private Requester requester() {
        return (Requester)this.branch.root().createRequest().withPreview(Previews.LUKE_CAGE);
    }

    private static class StatusChecks {
        final List<GHBranchProtection.Check> checks = new ArrayList<GHBranchProtection.Check>();
        boolean strict;

        private StatusChecks() {
        }
    }

    private static class Restrictions {
        private Set<String> teams = new HashSet<String>();
        private Set<String> users = new HashSet<String>();

        private Restrictions() {
        }
    }
}

