/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHCommitComment {
    private GHRepository owner;
    String updated_at;
    String created_at;
    String body;
    String url;
    String html_url;
    String commit_id;
    Integer line;
    int id;
    String path;
    User user;

    public GHRepository getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    public Date getUpdatedAt() {
        return GitHub.parseDate(this.updated_at);
    }

    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getSHA1() {
        return this.commit_id;
    }

    public String getBody() {
        return this.body;
    }

    public String getPath() {
        return this.path;
    }

    public int getLine() {
        return this.line != null ? this.line : -1;
    }

    public int getId() {
        return this.id;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root.getUser(this.user.login);
    }

    public GHCommit getCommit() throws IOException {
        return this.getOwner().getCommit(this.getSHA1());
    }

    public void update(String body) throws IOException {
        GHCommitComment r = (GHCommitComment)((Object)new Requester(this.owner.root).with("body", body).withCredential().method("PATCH").to(this.getApiTail(), GHCommitComment.class));
        this.body = body;
    }

    public void delete() throws IOException {
        new Requester(this.owner.root).withCredential().method("DELETE").to(this.getApiTail());
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/comments/%s", this.owner.getOwnerName(), this.owner.getName(), this.id);
    }

    GHCommitComment wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static class User {
        String url;
        String avatar_url;
        String login;
        String gravatar_id;
        int id;

        User() {
        }
    }
}

