/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.extras;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.connector.GitHubConnector;
import org.kohsuke.github.connector.GitHubConnectorRequest;
import org.kohsuke.github.connector.GitHubConnectorResponse;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HttpClientGitHubConnector
implements GitHubConnector {
    private final HttpClient client;

    public HttpClientGitHubConnector() {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build());
    }

    public HttpClientGitHubConnector(HttpClient client) {
        this.client = client;
    }

    @Override
    public GitHubConnectorResponse send(GitHubConnectorRequest connectorRequest) throws IOException {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        try {
            builder.uri(connectorRequest.url().toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URL", e);
        }
        for (Map.Entry<String, List<String>> e : connectorRequest.allHeaders().entrySet()) {
            List<String> v = e.getValue();
            if (v == null) continue;
            builder.header(e.getKey(), String.join((CharSequence)", ", v));
        }
        HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.noBody();
        if (connectorRequest.hasBody()) {
            publisher = HttpRequest.BodyPublishers.ofByteArray(IOUtils.toByteArray((InputStream)connectorRequest.body()));
        }
        builder.method(connectorRequest.method(), publisher);
        HttpRequest request = builder.build();
        try {
            HttpResponse<InputStream> httpResponse = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            return new HttpClientGitHubConnectorResponse(connectorRequest, httpResponse);
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.getMessage()).initCause(e);
        }
    }

    private static class HttpClientGitHubConnectorResponse
    extends GitHubConnectorResponse.ByteArrayResponse {
        @Nonnull
        private final HttpResponse<InputStream> response;

        protected HttpClientGitHubConnectorResponse(@Nonnull GitHubConnectorRequest request, @Nonnull HttpResponse<InputStream> response) {
            super(request, response.statusCode(), response.headers().map());
            this.response = response;
        }

        @Override
        @CheckForNull
        protected InputStream rawBodyStream() throws IOException {
            return this.response.body();
        }

        @Override
        public void close() throws IOException {
            super.close();
            IOUtils.closeQuietly((InputStream)this.response.body());
        }
    }
}

