/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Locale;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHReleaseBuilder {
    private final GHRepository repo;
    private final Requester builder;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Acceptable risk")
    public GHReleaseBuilder(GHRepository ghRepository, String tag) {
        this.repo = ghRepository;
        this.builder = (Requester)this.repo.root().createRequest().method("POST");
        this.builder.with("tag_name", tag);
    }

    public GHReleaseBuilder body(String body) {
        this.builder.with("body", body);
        return this;
    }

    public GHReleaseBuilder commitish(String commitish) {
        this.builder.with("target_commitish", commitish);
        return this;
    }

    public GHReleaseBuilder draft(boolean draft) {
        this.builder.with("draft", draft);
        return this;
    }

    public GHReleaseBuilder name(String name) {
        this.builder.with("name", name);
        return this;
    }

    public GHReleaseBuilder prerelease(boolean prerelease) {
        this.builder.with("prerelease", prerelease);
        return this;
    }

    public GHReleaseBuilder categoryName(String categoryName) {
        this.builder.with("discussion_category_name", categoryName);
        return this;
    }

    public GHReleaseBuilder makeLatest(MakeLatest latest) {
        this.builder.with("make_latest", latest);
        return this;
    }

    public GHRelease create() throws IOException {
        return ((Requester)this.builder.withUrlPath(this.repo.getApiTailUrl("releases"), new String[0])).fetch(GHRelease.class).wrap(this.repo);
    }

    public static enum MakeLatest {
        TRUE,
        FALSE,
        LEGACY;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

