/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHIssue {
    GitHub root;
    GHRepository owner;
    private String gravatar_id;
    private String body;
    private String title;
    private String state;
    private String created_at;
    private String updated_at;
    private String html_url;
    private List<String> labels;
    private int number;
    private int votes;
    private int comments;
    private int position;

    GHIssue wrap(GHRepository owner) {
        this.owner = owner;
        this.root = owner.root;
        return this;
    }

    static GHIssue[] wrap(GHIssue[] issues, GHRepository owner) {
        for (GHIssue i : issues) {
            i.wrap(owner);
        }
        return issues;
    }

    public GHRepository getRepository() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    public URL getUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getTitle() {
        return this.title;
    }

    public GHIssueState getState() {
        return Enum.valueOf(GHIssueState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public Collection<String> getLabels() {
        if (this.labels == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.labels);
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    public Date getUpdatedAt() {
        return GitHub.parseDate(this.updated_at);
    }

    public void comment(String message) throws IOException {
        new Poster(this.root).withCredential().with("body", message).to(this.getApiRoute() + "/comments", null, "POST");
    }

    private void edit(String key, Object value) throws IOException {
        new Poster(this.root).withCredential()._with(key, value).to(this.getApiRoute(), null, "PATCH");
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void assignTo(GHUser user) throws IOException {
        this.edit("assignee", user.getLogin());
    }

    public void setLabels(String ... labels) throws IOException {
        this.edit("assignee", labels);
    }

    public List<GHIssueComment> getComments() throws IOException {
        return this.listComments().asList();
    }

    public PagedIterable<GHIssueComment> listComments() throws IOException {
        return new PagedIterable<GHIssueComment>(){

            @Override
            public PagedIterator<GHIssueComment> iterator() {
                return new PagedIterator<GHIssueComment>(GHIssue.this.root.retrievePaged(GHIssue.this.getApiRoute() + "/comments", GHIssueComment[].class, false)){

                    protected void wrapUp(GHIssueComment[] page) {
                        for (GHIssueComment c : page) {
                            c.wrapUp(GHIssue.this);
                        }
                    }
                };
            }
        };
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/issues/" + this.number;
    }
}

