/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Set;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.JsonUsers;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHUser
extends GHPerson {
    private String name;
    private String company;
    private String location;
    private String created_at;
    private String blog;
    private String email;
    private int followers_count;

    public String getName() {
        return this.name;
    }

    public String getCompany() {
        return this.company;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCreatedAt() {
        return this.created_at;
    }

    public String getBlog() {
        return this.blog;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public int getPublicGistCount() {
        return this.public_gist_count;
    }

    public int getPublicRepoCount() {
        return this.public_repo_count;
    }

    public int getFollowingCount() {
        return this.following_count;
    }

    public int getId() {
        return this.id;
    }

    public int getFollowersCount() {
        return this.followers_count;
    }

    public void follow() throws IOException {
        new Poster(this.root).withCredential().to(this.root.getApiURL("/user/follow/" + this.login));
    }

    public void unfollow() throws IOException {
        new Poster(this.root).withCredential().to(this.root.getApiURL("/user/unfollow/" + this.login));
    }

    public Set<GHUser> getFollows() throws IOException {
        return this.root.retrieve("/user/show/" + this.login + "/following", JsonUsers.class).toSet(this.root);
    }

    public Set<GHUser> getFollowers() throws IOException {
        return this.root.retrieve("/user/show/" + this.login + "/followers", JsonUsers.class).toSet(this.root);
    }

    public String toString() {
        return "User:" + this.login;
    }

    public int hashCode() {
        return this.login.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHUser) {
            GHUser that = (GHUser)obj;
            return this.login.equals(that.login);
        }
        return false;
    }
}

