/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PagedIterator<T>
implements Iterator<T> {
    private final Iterator<T[]> base;
    private T[] current;
    private int pos;

    PagedIterator(Iterator<T[]> base) {
        this.base = base;
    }

    protected abstract void wrapUp(T[] var1);

    @Override
    public boolean hasNext() {
        return this.current != null && this.pos < this.current.length || this.base.hasNext();
    }

    @Override
    public T next() {
        this.fetch();
        return this.current[this.pos++];
    }

    private void fetch() {
        while (this.current == null || this.current.length <= this.pos) {
            this.current = this.base.next();
            this.wrapUp(this.current);
            this.pos = 0;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<T> nextPage() {
        this.fetch();
        List<T> r = Arrays.asList(this.current);
        r = r.subList(this.pos, r.size());
        this.current = null;
        this.pos = 0;
        return r;
    }
}

