/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Date;
import java.util.List;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.TrafficInfo;

public abstract class GHRepositoryTraffic
implements TrafficInfo {
    private int count;
    private int uniques;

    GHRepositoryTraffic() {
    }

    GHRepositoryTraffic(int count, int uniques) {
        this.count = count;
        this.uniques = uniques;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getUniques() {
        return this.uniques;
    }

    public abstract List<? extends DailyInfo> getDailyInfo();

    public static abstract class DailyInfo
    implements TrafficInfo {
        private String timestamp;
        private int count;
        private int uniques;

        public Date getTimestamp() {
            return GitHubClient.parseDate(this.timestamp);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int getUniques() {
            return this.uniques;
        }

        DailyInfo() {
        }

        DailyInfo(String timestamp, Integer count, Integer uniques) {
            this.timestamp = timestamp;
            this.count = count;
            this.uniques = uniques;
        }
    }
}

