/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHBlobBuilder;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckRunBuilder;
import org.kohsuke.github.GHCheckRunsIterable;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitBuilder;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitQueryBuilder;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHCompare;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHContentBuilder;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHContentWithLicense;
import org.kohsuke.github.GHDeployKey;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentBuilder;
import org.kohsuke.github.GHDeploymentState;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHDeploymentStatusBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHHooks;
import org.kohsuke.github.GHInvitation;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueBuilder;
import org.kohsuke.github.GHIssueEvent;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHLicense;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHNotificationStream;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPermission;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestQueryBuilder;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepositoryCloneTraffic;
import org.kohsuke.github.GHRepositoryStatistics;
import org.kohsuke.github.GHRepositoryViewTraffic;
import org.kohsuke.github.GHStargazer;
import org.kohsuke.github.GHSubscription;
import org.kohsuke.github.GHTag;
import org.kohsuke.github.GHTagObject;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.MarkdownMode;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SkipFromToString;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
@BridgeMethodsAdded
public class GHRepository
extends GHObject {
    transient GitHub root;
    private String nodeId;
    private String description;
    private String homepage;
    private String name;
    private String full_name;
    private String html_url;
    private GHLicense license;
    private String git_url;
    private String ssh_url;
    private String clone_url;
    private String svn_url;
    private String mirror_url;
    private GHUser owner;
    private boolean has_issues;
    private boolean has_wiki;
    private boolean fork;
    private boolean has_downloads;
    private boolean has_pages;
    private boolean archived;
    private boolean has_projects;
    private boolean allow_squash_merge;
    private boolean allow_merge_commit;
    private boolean allow_rebase_merge;
    private boolean delete_branch_on_merge;
    @JsonProperty(value="private")
    private boolean _private;
    private int forks_count;
    private int stargazers_count;
    private int watchers_count;
    private int size;
    private int open_issues_count;
    private int subscribers_count;
    private String pushed_at;
    private Map<Integer, GHMilestone> milestones = new WeakHashMap<Integer, GHMilestone>();
    private String default_branch;
    private String language;
    private Map<String, GHCommit> commits = new WeakHashMap<String, GHCommit>();
    @SkipFromToString
    private GHRepoPermission permissions;
    private GHRepository source;
    private GHRepository parent;
    private Boolean isTemplate;
    @SkipFromToString
    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="It causes a performance degradation, but we have already exposed it to the API")
    private final Set<URL> postCommitHooks = new AbstractSet<URL>(){

        private List<URL> getPostCommitHooks() {
            try {
                ArrayList<URL> r = new ArrayList<URL>();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web")) continue;
                    r.add(new URL(h.getConfig().get("url")));
                }
                return r;
            }
            catch (IOException e) {
                throw new GHException("Failed to retrieve post-commit hooks", e);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return this.getPostCommitHooks().iterator();
        }

        @Override
        public int size() {
            return this.getPostCommitHooks().size();
        }

        @Override
        public boolean add(URL url) {
            try {
                GHRepository.this.createWebHook(url);
                return true;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }

        @Override
        public boolean remove(Object url) {
            try {
                String _url = ((URL)url).toExternalForm();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web") || !h.getConfig().get("url").equals(_url)) continue;
                    h.delete();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }
    };

    static GHRepository read(GitHub root, String owner, String name) throws IOException {
        return ((Requester)root.createRequest().withUrlPath("/repos/" + owner + '/' + name, new String[0])).fetch(GHRepository.class).wrap(root);
    }

    public GHDeploymentBuilder createDeployment(String ref) {
        return new GHDeploymentBuilder(this, ref);
    }

    @Deprecated
    public PagedIterable<GHDeploymentStatus> getDeploymentStatuses(int id) throws IOException {
        return this.getDeployment(id).listStatuses();
    }

    public PagedIterable<GHDeployment> listDeployments(String sha, String ref, String task, String environment) {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().with("sha", sha)).with("ref", ref)).with("task", task)).with("environment", environment)).withUrlPath(this.getApiTailUrl("deployments"), new String[0])).toIterable(GHDeployment[].class, item -> item.wrap(this));
    }

    public GHDeployment getDeployment(long id) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("deployments/" + id), new String[0])).fetch(GHDeployment.class).wrap(this);
    }

    @Deprecated
    public GHDeploymentStatusBuilder createDeployStatus(int deploymentId, GHDeploymentState ghDeploymentState) throws IOException {
        return this.getDeployment(deploymentId).createStatus(ghDeploymentState);
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getGitTransportUrl() {
        return this.git_url;
    }

    public String getHttpTransportUrl() {
        return this.clone_url;
    }

    @Deprecated
    public String gitHttpTransportUrl() {
        return this.clone_url;
    }

    public String getSvnUrl() {
        return this.svn_url;
    }

    public String getMirrorUrl() {
        return this.mirror_url;
    }

    public String getSshUrl() {
        return this.ssh_url;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.full_name;
    }

    public boolean hasPullAccess() {
        return this.permissions != null && this.permissions.pull;
    }

    public boolean hasPushAccess() {
        return this.permissions != null && this.permissions.push;
    }

    public boolean hasAdminAccess() {
        return this.permissions != null && this.permissions.admin;
    }

    public String getLanguage() {
        return this.language;
    }

    public GHUser getOwner() throws IOException {
        return this.root.isOffline() ? this.owner : this.root.getUser(this.getOwnerName());
    }

    public GHIssue getIssue(int id) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("issues/" + id), new String[0])).fetch(GHIssue.class).wrap(this);
    }

    public GHIssueBuilder createIssue(String title) {
        return new GHIssueBuilder(this, title);
    }

    public List<GHIssue> getIssues(GHIssueState state) throws IOException {
        return this.listIssues(state).toList();
    }

    public List<GHIssue> getIssues(GHIssueState state, GHMilestone milestone) throws IOException {
        Requester requester = (Requester)((Requester)this.root.createRequest().with("state", state)).with("milestone", milestone == null ? "none" : "" + milestone.getNumber());
        return ((Requester)requester.withUrlPath(this.getApiTailUrl("issues"), new String[0])).toIterable(GHIssue[].class, item -> item.wrap(this)).toList();
    }

    public PagedIterable<GHIssue> listIssues(GHIssueState state) {
        return ((Requester)((Requester)this.root.createRequest().with("state", state)).withUrlPath(this.getApiTailUrl("issues"), new String[0])).toIterable(GHIssue[].class, item -> item.wrap(this));
    }

    public GHReleaseBuilder createRelease(String tag) {
        return new GHReleaseBuilder(this, tag);
    }

    public GHRef createRef(String name, String sha) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("ref", name)).with("sha", sha)).withUrlPath(this.getApiTailUrl("git/refs"), new String[0])).fetch(GHRef.class).wrap(this.root);
    }

    public List<GHRelease> getReleases() throws IOException {
        return this.listReleases().toList();
    }

    public GHRelease getRelease(long id) throws IOException {
        try {
            return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("releases/" + id), new String[0])).fetch(GHRelease.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public GHRelease getReleaseByTagName(String tag) throws IOException {
        try {
            return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("releases/tags/" + tag), new String[0])).fetch(GHRelease.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public GHRelease getLatestRelease() throws IOException {
        try {
            return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("releases/latest"), new String[0])).fetch(GHRelease.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public PagedIterable<GHRelease> listReleases() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("releases"), new String[0])).toIterable(GHRelease[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHTag> listTags() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("tags"), new String[0])).toIterable(GHTag[].class, item -> item.wrap(this));
    }

    public Map<String, Long> listLanguages() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("languages"), new String[0])).fetch(HashMap.class);
    }

    public String getOwnerName() {
        return this.owner.login != null ? this.owner.login : this.owner.name;
    }

    public boolean hasIssues() {
        return this.has_issues;
    }

    public boolean hasProjects() {
        return this.has_projects;
    }

    public boolean hasWiki() {
        return this.has_wiki;
    }

    public boolean isFork() {
        return this.fork;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isAllowSquashMerge() {
        return this.allow_squash_merge;
    }

    public boolean isAllowMergeCommit() {
        return this.allow_merge_commit;
    }

    public boolean isAllowRebaseMerge() {
        return this.allow_rebase_merge;
    }

    public boolean isDeleteBranchOnMerge() {
        return this.delete_branch_on_merge;
    }

    @Deprecated
    public int getForks() {
        return this.getForksCount();
    }

    public int getForksCount() {
        return this.forks_count;
    }

    public int getStargazersCount() {
        return this.stargazers_count;
    }

    public boolean isPrivate() {
        return this._private;
    }

    @Deprecated
    @Preview
    public boolean isTemplate() {
        if (this.isTemplate == null) {
            try {
                this.populate();
            }
            catch (IOException e) {
                throw new GHException("Could not populate the template setting of the repository", e);
            }
            this.isTemplate = Boolean.TRUE.equals(this.isTemplate);
        }
        return this.isTemplate;
    }

    public boolean hasDownloads() {
        return this.has_downloads;
    }

    public boolean hasPages() {
        return this.has_pages;
    }

    @Deprecated
    public int getWatchers() {
        return this.getWatchersCount();
    }

    public int getWatchersCount() {
        return this.watchers_count;
    }

    public int getOpenIssueCount() {
        return this.open_issues_count;
    }

    public int getSubscribersCount() {
        return this.subscribers_count;
    }

    public Date getPushedAt() {
        return GitHubClient.parseDate(this.pushed_at);
    }

    public String getDefaultBranch() {
        return this.default_branch;
    }

    @Deprecated
    public String getMasterBranch() {
        return this.default_branch;
    }

    public int getSize() {
        return this.size;
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getCollaborators() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listCollaborators().toList());
    }

    public PagedIterable<GHUser> listCollaborators() throws IOException {
        return this.listUsers("collaborators");
    }

    public PagedIterable<GHUser> listAssignees() throws IOException {
        return this.listUsers("assignees");
    }

    public boolean hasAssignee(GHUser u) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("assignees/" + u.getLogin()), new String[0])).fetchHttpStatusCode() / 100 == 2;
    }

    public Set<String> getCollaboratorNames() throws IOException {
        HashSet<String> r = new HashSet<String>();
        PagedIterable users = ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("collaborators"), new String[0])).toIterable(GHUser[].class, null);
        for (GHUser u : (GHUser[])users.toArray()) {
            r.add(u.login);
        }
        return r;
    }

    public GHPermissionType getPermission(String user) throws IOException {
        GHPermission perm = ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("collaborators/" + user + "/permission"), new String[0])).fetch(GHPermission.class);
        perm.wrapUp(this.root);
        return perm.getPermissionType();
    }

    public GHPermissionType getPermission(GHUser u) throws IOException {
        return this.getPermission(u.getLogin());
    }

    public Set<GHTeam> getTeams() throws IOException {
        GHOrganization org = this.root.getOrganization(this.getOwnerName());
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("teams"), new String[0])).toIterable(GHTeam[].class, item -> item.wrapUp(org)).toSet();
    }

    public void addCollaborators(GHOrganization.Permission permission, GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users), permission);
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "PUT", null);
    }

    public void addCollaborators(Collection<GHUser> users, GHOrganization.Permission permission) throws IOException {
        this.modifyCollaborators(users, "PUT", permission);
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "DELETE", null);
    }

    private void modifyCollaborators(@NonNull Collection<GHUser> users, @NonNull String method, @CheckForNull GHOrganization.Permission permission) throws IOException {
        Requester requester = (Requester)this.root.createRequest().method(method);
        if (permission != null) {
            requester = (Requester)((Requester)requester.with("permission", permission)).inBody();
        }
        for (GHUser user : new LinkedHashSet<GHUser>(users)) {
            ((Requester)requester.withUrlPath(this.getApiTailUrl("collaborators/" + user.getLogin()), new String[0])).send();
        }
    }

    public void setEmailServiceHook(String address) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("address", address);
        ((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("name", "email")).with("config", config)).with("active", true)).withUrlPath(this.getApiTailUrl("hooks"), new String[0])).send();
    }

    private void edit(String key, String value) throws IOException {
        Requester requester = this.root.createRequest();
        if (!key.equals("name")) {
            requester.with("name", this.name);
        }
        ((Requester)((Requester)((Requester)requester.with(key, value)).method("PATCH")).withUrlPath(this.getApiTailUrl(""), new String[0])).send();
    }

    public void enableIssueTracker(boolean v) throws IOException {
        this.edit("has_issues", String.valueOf(v));
    }

    public void enableProjects(boolean v) throws IOException {
        this.edit("has_projects", String.valueOf(v));
    }

    public void enableWiki(boolean v) throws IOException {
        this.edit("has_wiki", String.valueOf(v));
    }

    public void enableDownloads(boolean v) throws IOException {
        this.edit("has_downloads", String.valueOf(v));
    }

    public void renameTo(String name) throws IOException {
        this.edit("name", name);
    }

    public void setDescription(String value) throws IOException {
        this.edit("description", value);
    }

    public void setHomepage(String value) throws IOException {
        this.edit("homepage", value);
    }

    public void setDefaultBranch(String value) throws IOException {
        this.edit("default_branch", value);
    }

    public void setPrivate(boolean value) throws IOException {
        this.edit("private", Boolean.toString(value));
    }

    public void allowSquashMerge(boolean value) throws IOException {
        this.edit("allow_squash_merge", Boolean.toString(value));
    }

    public void allowMergeCommit(boolean value) throws IOException {
        this.edit("allow_merge_commit", Boolean.toString(value));
    }

    public void allowRebaseMerge(boolean value) throws IOException {
        this.edit("allow_rebase_merge", Boolean.toString(value));
    }

    public void deleteBranchOnMerge(boolean value) throws IOException {
        this.edit("delete_branch_on_merge", Boolean.toString(value));
    }

    public void delete() throws IOException {
        try {
            ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.getApiTailUrl(""), new String[0])).send();
        }
        catch (FileNotFoundException x) {
            throw (FileNotFoundException)new FileNotFoundException("Failed to delete " + this.getOwnerName() + "/" + this.name + "; might not exist, or you might need the delete_repo scope in your token: http://stackoverflow.com/a/19327004/12916").initCause(x);
        }
    }

    public void archive() throws IOException {
        this.edit("archived", "true");
        this.archived = true;
    }

    public PagedIterable<GHRepository> listForks() {
        return this.listForks(null);
    }

    public PagedIterable<GHRepository> listForks(ForkSort sort) {
        return ((Requester)((Requester)this.root.createRequest().with("sort", sort)).withUrlPath(this.getApiTailUrl("forks"), new String[0])).toIterable(GHRepository[].class, item -> item.wrap(this.root));
    }

    public GHRepository fork() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("POST")).withUrlPath(this.getApiTailUrl("forks"), new String[0])).send();
        for (int i = 0; i < 10; ++i) {
            GHRepository r = this.root.getMyself().getRepository(this.name);
            if (r != null) {
                return r;
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
        throw new IOException(this + " was forked but can't find the new repository");
    }

    public GHRepository forkTo(GHOrganization org) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("organization", org.getLogin())).withUrlPath(this.getApiTailUrl("forks"), new String[0])).send();
        for (int i = 0; i < 10; ++i) {
            GHRepository r = org.getRepository(this.name);
            if (r != null) {
                return r;
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
        throw new IOException(this + " was forked into " + org.getLogin() + " but can't find the new repository");
    }

    public GHPullRequest getPullRequest(int i) throws IOException {
        return ((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.shadow-cat-preview+json")).withUrlPath(this.getApiTailUrl("pulls/" + i), new String[0])).fetch(GHPullRequest.class).wrapUp(this);
    }

    public List<GHPullRequest> getPullRequests(GHIssueState state) throws IOException {
        return this.queryPullRequests().state(state).list().toList();
    }

    @Deprecated
    public PagedIterable<GHPullRequest> listPullRequests(GHIssueState state) {
        return this.queryPullRequests().state(state).list();
    }

    public GHPullRequestQueryBuilder queryPullRequests() {
        return new GHPullRequestQueryBuilder(this);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body) throws IOException {
        return this.createPullRequest(title, head, base, body, true);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body, boolean maintainerCanModify) throws IOException {
        return this.createPullRequest(title, head, base, body, maintainerCanModify, false);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body, boolean maintainerCanModify, boolean draft) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).withPreview("application/vnd.github.shadow-cat-preview+json")).with("title", title)).with("head", head)).with("base", base)).with("body", body)).with("maintainer_can_modify", maintainerCanModify)).with("draft", draft)).withUrlPath(this.getApiTailUrl("pulls"), new String[0])).fetch(GHPullRequest.class).wrapUp(this);
    }

    public List<GHHook> getHooks() throws IOException {
        return GHHooks.repoContext(this, this.owner).getHooks();
    }

    public GHHook getHook(int id) throws IOException {
        return GHHooks.repoContext(this, this.owner).getHook(id);
    }

    public GHCompare getCompare(String id1, String id2) throws IOException {
        GHCompare compare = ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl(String.format("compare/%s...%s", id1, id2)), new String[0])).fetch(GHCompare.class);
        return compare.wrap(this);
    }

    public GHCompare getCompare(GHCommit id1, GHCommit id2) throws IOException {
        return this.getCompare(id1.getSHA1(), id2.getSHA1());
    }

    public GHCompare getCompare(GHBranch id1, GHBranch id2) throws IOException {
        String ownerName2;
        String ownerName1;
        GHRepository owner1 = id1.getOwner();
        GHRepository owner2 = id2.getOwner();
        if (owner1 != null && owner2 != null && !StringUtils.equals((CharSequence)(ownerName1 = owner1.getOwnerName()), (CharSequence)(ownerName2 = owner2.getOwnerName()))) {
            String qualifiedName1 = String.format("%s:%s", ownerName1, id1.getName());
            String qualifiedName2 = String.format("%s:%s", ownerName2, id2.getName());
            return this.getCompare(qualifiedName1, qualifiedName2);
        }
        return this.getCompare(id1.getName(), id2.getName());
    }

    public GHRef[] getRefs() throws IOException {
        return this.listRefs().toArray();
    }

    public PagedIterable<GHRef> listRefs() throws IOException {
        return this.listRefs("");
    }

    public GHRef[] getRefs(String refType) throws IOException {
        return this.listRefs(refType).toArray();
    }

    public PagedIterable<GHRef> listRefs(String refType) throws IOException {
        return GHRef.readMatching(this, refType);
    }

    public GHRef getRef(String refName) throws IOException {
        return GHRef.read(this, refName);
    }

    public GHTagObject getTagObject(String sha) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("git/tags/" + sha), new String[0])).fetch(GHTagObject.class).wrap(this);
    }

    public GHTree getTree(String sha) throws IOException {
        String url = String.format("/repos/%s/%s/git/trees/%s", this.getOwnerName(), this.name, sha);
        return ((Requester)this.root.createRequest().withUrlPath(url, new String[0])).fetch(GHTree.class).wrap(this);
    }

    public GHTreeBuilder createTree() {
        return new GHTreeBuilder(this);
    }

    public GHTree getTreeRecursive(String sha, int recursive) throws IOException {
        String url = String.format("/repos/%s/%s/git/trees/%s", this.getOwnerName(), this.name, sha);
        return ((Requester)((Requester)this.root.createRequest().with("recursive", recursive)).withUrlPath(url, new String[0])).fetch(GHTree.class).wrap(this);
    }

    public GHBlob getBlob(String blobSha) throws IOException {
        String target = this.getApiTailUrl("git/blobs/" + blobSha);
        return ((Requester)this.root.createRequest().withUrlPath(target, new String[0])).fetch(GHBlob.class);
    }

    public GHBlobBuilder createBlob() {
        return new GHBlobBuilder(this);
    }

    public InputStream readBlob(String blobSha) throws IOException {
        String target = this.getApiTailUrl("git/blobs/" + blobSha);
        return ((Requester)((Requester)this.root.createRequest().withHeader("Accept", "application/vnd.github.v3.raw")).withUrlPath(target, new String[0])).fetchStream();
    }

    public GHCommit getCommit(String sha1) throws IOException {
        GHCommit c = this.commits.get(sha1);
        if (c == null) {
            c = ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s", this.getOwnerName(), this.name, sha1), new String[0])).fetch(GHCommit.class).wrapUp(this);
            this.commits.put(sha1, c);
        }
        return c;
    }

    public GHCommitBuilder createCommit() {
        return new GHCommitBuilder(this);
    }

    public PagedIterable<GHCommit> listCommits() {
        return ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/commits", this.getOwnerName(), this.name), new String[0])).toIterable(GHCommit[].class, item -> item.wrapUp(this));
    }

    public GHCommitQueryBuilder queryCommits() {
        return new GHCommitQueryBuilder(this);
    }

    public PagedIterable<GHCommitComment> listCommitComments() {
        return ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/comments", this.getOwnerName(), this.name), new String[0])).toIterable(GHCommitComment[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHCommitComment> listCommitComments(String commitSha) {
        return ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/comments", this.getOwnerName(), this.name, commitSha), new String[0])).toIterable(GHCommitComment[].class, item -> item.wrap(this));
    }

    public GHLicense getLicense() throws IOException {
        GHContentWithLicense lic = this.getLicenseContent_();
        return lic != null ? lic.license : null;
    }

    public GHContent getLicenseContent() throws IOException {
        return this.getLicenseContent_();
    }

    private GHContentWithLicense getLicenseContent_() throws IOException {
        try {
            return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("license"), new String[0])).fetch(GHContentWithLicense.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public PagedIterable<GHCommitStatus> listCommitStatuses(String sha1) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/statuses/%s", this.getOwnerName(), this.name, sha1), new String[0])).toIterable(GHCommitStatus[].class, item -> item.wrapUp(this.root));
    }

    public GHCommitStatus getLastCommitStatus(String sha1) throws IOException {
        List<GHCommitStatus> v = this.listCommitStatuses(sha1).toList();
        return v.isEmpty() ? null : v.get(0);
    }

    @Preview
    @Deprecated
    public PagedIterable<GHCheckRun> getCheckRuns(String ref) throws IOException {
        GitHubRequest request = ((Requester)((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/check-runs", this.getOwnerName(), this.name, ref), new String[0])).withPreview("application/vnd.github.antiope-preview+json")).build();
        return new GHCheckRunsIterable(this.root, request);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description, String context) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("state", state)).with("target_url", targetUrl)).with("description", description)).with("context", context)).withUrlPath(String.format("/repos/%s/%s/statuses/%s", this.getOwnerName(), this.name, sha1), new String[0])).fetch(GHCommitStatus.class).wrapUp(this.root);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description) throws IOException {
        return this.createCommitStatus(sha1, state, targetUrl, description, null);
    }

    @Preview
    @Deprecated
    @NonNull
    public GHCheckRunBuilder createCheckRun(@NonNull String name, @NonNull String headSHA) {
        return new GHCheckRunBuilder(this, name, headSHA);
    }

    @Preview
    @Deprecated
    @NonNull
    public GHCheckRunBuilder updateCheckRun(long checkId) {
        return new GHCheckRunBuilder(this, checkId);
    }

    public PagedIterable<GHEventInfo> listEvents() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/events", this.getOwnerName(), this.name), new String[0])).toIterable(GHEventInfo[].class, item -> item.wrapUp(this.root));
    }

    public PagedIterable<GHLabel> listLabels() throws IOException {
        return GHLabel.readAll(this);
    }

    public GHLabel getLabel(String name) throws IOException {
        return GHLabel.read(this, name);
    }

    public GHLabel createLabel(String name, String color) throws IOException {
        return (GHLabel)((GHLabel.Creator)((GHLabel.Creator)((GHLabel.Creator)GHLabel.create(this).name(name)).color(color)).description("")).done();
    }

    public GHLabel createLabel(String name, String color, String description) throws IOException {
        return (GHLabel)((GHLabel.Creator)((GHLabel.Creator)((GHLabel.Creator)GHLabel.create(this).name(name)).color(color)).description(description)).done();
    }

    public PagedIterable<GHInvitation> listInvitations() {
        return ((Requester)this.root.createRequest().withUrlPath(String.format("/repos/%s/%s/invitations", this.getOwnerName(), this.name), new String[0])).toIterable(GHInvitation[].class, item -> item.wrapUp(this.root));
    }

    public PagedIterable<GHUser> listSubscribers() {
        return this.listUsers("subscribers");
    }

    public PagedIterable<GHUser> listStargazers() {
        return this.listUsers("stargazers");
    }

    public PagedIterable<GHStargazer> listStargazers2() {
        return ((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.v3.star+json")).withUrlPath(this.getApiTailUrl("stargazers"), new String[0])).toIterable(GHStargazer[].class, item -> item.wrapUp(this));
    }

    private PagedIterable<GHUser> listUsers(String suffix) {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl(suffix), new String[0])).toIterable(GHUser[].class, item -> item.wrapUp(this.root));
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        return GHHooks.repoContext(this, this.owner).createHook(name, config, events, active);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    @Deprecated
    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="It causes a performance degradation, but we have already exposed it to the API")
    public Set<URL> getPostCommitHooks() {
        return this.postCommitHooks;
    }

    GHRepository wrap(GitHub root) {
        this.root = root;
        if (root.isOffline() && this.owner != null) {
            this.owner.wrapUp(root);
        }
        if (this.source != null) {
            this.source.wrap(root);
        }
        if (this.parent != null) {
            this.parent.wrap(root);
        }
        return this;
    }

    public Map<String, GHBranch> getBranches() throws IOException {
        TreeMap<String, GHBranch> r = new TreeMap<String, GHBranch>();
        for (GHBranch p : ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("branches"), new String[0])).toIterable(GHBranch[].class, item -> item.wrap(this)).toArray()) {
            r.put(p.getName(), p);
        }
        return r;
    }

    public GHBranch getBranch(String name) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("branches/" + name), new String[0])).fetch(GHBranch.class).wrap(this);
    }

    public Map<Integer, GHMilestone> getMilestones() throws IOException {
        TreeMap<Integer, GHMilestone> milestones = new TreeMap<Integer, GHMilestone>();
        for (GHMilestone m : this.listMilestones(GHIssueState.OPEN)) {
            milestones.put(m.getNumber(), m);
        }
        return milestones;
    }

    public PagedIterable<GHMilestone> listMilestones(GHIssueState state) {
        return ((Requester)((Requester)this.root.createRequest().with("state", state)).withUrlPath(this.getApiTailUrl("milestones"), new String[0])).toIterable(GHMilestone[].class, item -> item.wrap(this));
    }

    public GHMilestone getMilestone(int number) throws IOException {
        GHMilestone m = this.milestones.get(number);
        if (m == null) {
            m = ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("milestones/" + number), new String[0])).fetch(GHMilestone.class);
            m.owner = this;
            m.root = this.root;
            this.milestones.put(m.getNumber(), m);
        }
        return m;
    }

    public GHContent getFileContent(String path) throws IOException {
        return this.getFileContent(path, null);
    }

    public GHContent getFileContent(String path, String ref) throws IOException {
        Requester requester = this.root.createRequest();
        String target = this.getApiTailUrl("contents/" + path);
        return ((Requester)((Requester)requester.with("ref", ref)).withUrlPath(target, new String[0])).fetch(GHContent.class).wrap(this);
    }

    public List<GHContent> getDirectoryContent(String path) throws IOException {
        return this.getDirectoryContent(path, null);
    }

    public List<GHContent> getDirectoryContent(String path, String ref) throws IOException {
        Requester requester = this.root.createRequest();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String target = this.getApiTailUrl("contents/" + path);
        return ((Requester)((Requester)requester.with("ref", ref)).withUrlPath(target, new String[0])).toIterable(GHContent[].class, item -> item.wrap(this)).toList();
    }

    public GHContent getReadme() throws IOException {
        Requester requester = this.root.createRequest();
        return ((Requester)requester.withUrlPath(this.getApiTailUrl("readme"), new String[0])).fetch(GHContent.class).wrap(this);
    }

    public GHContentBuilder createContent() {
        return new GHContentBuilder(this);
    }

    @Deprecated
    public GHContentUpdateResponse createContent(String content, String commitMessage, String path) throws IOException {
        return this.createContent().content(content).message(commitMessage).path(path).commit();
    }

    @Deprecated
    public GHContentUpdateResponse createContent(String content, String commitMessage, String path, String branch) throws IOException {
        return this.createContent().content(content).message(commitMessage).path(path).branch(branch).commit();
    }

    @Deprecated
    public GHContentUpdateResponse createContent(byte[] contentBytes, String commitMessage, String path) throws IOException {
        return this.createContent().content(contentBytes).message(commitMessage).path(path).commit();
    }

    @Deprecated
    public GHContentUpdateResponse createContent(byte[] contentBytes, String commitMessage, String path, String branch) throws IOException {
        return this.createContent().content(contentBytes).message(commitMessage).path(path).branch(branch).commit();
    }

    public GHMilestone createMilestone(String title, String description) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("title", title)).with("description", description)).withUrlPath(this.getApiTailUrl("milestones"), new String[0])).fetch(GHMilestone.class).wrap(this);
    }

    public GHDeployKey addDeployKey(String title, String key) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("title", title)).with("key", key)).withUrlPath(this.getApiTailUrl("keys"), new String[0])).fetch(GHDeployKey.class).wrap(this);
    }

    public List<GHDeployKey> getDeployKeys() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("keys"), new String[0])).toIterable(GHDeployKey[].class, item -> item.wrap(this)).toList();
    }

    public GHRepository getSource() throws IOException {
        if (this.fork && this.source == null) {
            this.populate();
        }
        if (this.source == null) {
            return null;
        }
        return this.source;
    }

    public GHRepository getParent() throws IOException {
        if (this.fork && this.parent == null) {
            this.populate();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent;
    }

    public GHSubscription subscribe(boolean subscribed, boolean ignored) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("subscribed", subscribed)).with("ignored", ignored)).withUrlPath(this.getApiTailUrl("subscription"), new String[0])).fetch(GHSubscription.class).wrapUp(this);
    }

    public GHSubscription getSubscription() throws IOException {
        try {
            return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("subscription"), new String[0])).fetch(GHSubscription.class).wrapUp(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public PagedIterable<Contributor> listContributors() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("contributors"), new String[0])).toIterable(Contributor[].class, item -> item.wrapUp(this.root));
    }

    public GHRepositoryStatistics getStatistics() {
        return new GHRepositoryStatistics(this);
    }

    public GHProject createProject(String name, String body) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).withPreview("application/vnd.github.inertia-preview+json")).with("name", name)).with("body", body)).withUrlPath(this.getApiTailUrl("projects"), new String[0])).fetch(GHProject.class).wrap(this);
    }

    public PagedIterable<GHProject> listProjects(GHProject.ProjectStateFilter status) throws IOException {
        return ((Requester)((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.inertia-preview+json")).with("state", status)).withUrlPath(this.getApiTailUrl("projects"), new String[0])).toIterable(GHProject[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHProject> listProjects() throws IOException {
        return this.listProjects(GHProject.ProjectStateFilter.OPEN);
    }

    public Reader renderMarkdown(String text, MarkdownMode mode) throws IOException {
        return new InputStreamReader(((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("text", text)).with("mode", mode == null ? null : mode.toString())).with("context", this.getFullName())).withUrlPath("/markdown", new String[0])).fetchStream(), "UTF-8");
    }

    public GHNotificationStream listNotifications() {
        return new GHNotificationStream(this.root, this.getApiTailUrl("/notifications"));
    }

    public GHRepositoryViewTraffic getViewTraffic() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("/traffic/views"), new String[0])).fetch(GHRepositoryViewTraffic.class);
    }

    public GHRepositoryCloneTraffic getCloneTraffic() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("/traffic/clones"), new String[0])).fetch(GHRepositoryCloneTraffic.class);
    }

    public int hashCode() {
        return ("Repository:" + this.getOwnerName() + ":" + this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHRepository) {
            GHRepository that = (GHRepository)obj;
            return this.getOwnerName().equals(that.getOwnerName()) && this.name.equals(that.name);
        }
        return false;
    }

    String getApiTailUrl(String tail) {
        if (tail.length() > 0 && !tail.startsWith("/")) {
            tail = '/' + tail;
        }
        return "/repos/" + this.getOwnerName() + "/" + this.name + tail;
    }

    public PagedIterable<GHIssueEvent> listIssueEvents() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("issues/events"), new String[0])).toIterable(GHIssueEvent[].class, item -> item.wrapUp(this.root));
    }

    public GHIssueEvent getIssueEvent(long id) throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("issues/events/" + id), new String[0])).fetch(GHIssueEvent.class).wrapUp(this.root);
    }

    public List<String> listTopics() throws IOException {
        Topics topics = ((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.mercy-preview+json")).withUrlPath(this.getApiTailUrl("topics"), new String[0])).fetch(Topics.class);
        return topics.names;
    }

    public void setTopics(List<String> topics) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("names", topics)).withPreview("application/vnd.github.mercy-preview+json")).withUrlPath(this.getApiTailUrl("topics"), new String[0])).send();
    }

    public GHTagObject createTag(String tag, String message, String object, String type) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).with("tag", tag)).with("message", message)).with("object", object)).with("type", type)).withUrlPath(this.getApiTailUrl("git/tags"), new String[0])).fetch(GHTagObject.class).wrap(this);
    }

    void populate() throws IOException {
        if (this.root.isOffline()) {
            return;
        }
        URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
        try {
            ((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.baptiste-preview+json")).setRawUrlPath(url.toString())).fetchInto(this).wrap(this.root);
        }
        catch (HttpException e) {
            if (e.getCause() instanceof JsonParseException) {
                ((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.baptiste-preview+json")).withUrlPath("/repos/" + this.full_name, new String[0])).fetchInto(this).wrap(this.root);
            }
            throw e;
        }
    }

    private static class Topics {
        public List<String> names;

        private Topics() {
        }
    }

    public static class Contributor
    extends GHUser {
        private int contributions;

        public int getContributions() {
            return this.contributions;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static enum ForkSort {
        NEWEST,
        OLDEST,
        STARGAZERS;

    }

    private static class GHRepoPermission {
        boolean pull;
        boolean push;
        boolean admin;

        private GHRepoPermission() {
        }
    }
}

