/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonSetter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.List;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckSuite;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestChanges;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRequestedAction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
public class GHEventPayload {
    protected GitHub root;
    private String action;
    private GHUser sender;
    private GHRepository repository;
    private GHOrganization organization;
    private GHAppInstallation installation;

    GHEventPayload() {
    }

    public String getAction() {
        return this.action;
    }

    public GHUser getSender() {
        return this.sender;
    }

    public void setSender(GHUser sender) {
        this.sender = sender;
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    public void setRepository(GHRepository repository) {
        this.repository = repository;
    }

    public GHOrganization getOrganization() {
        return this.organization;
    }

    public void setOrganization(GHOrganization organization) {
        this.organization = organization;
    }

    public GHAppInstallation getInstallation() {
        return this.installation;
    }

    void wrapUp(GitHub root) {
        this.root = root;
        if (this.sender != null) {
            this.sender.wrapUp(root);
        }
        if (this.repository != null) {
            this.repository.wrap(root);
        }
        if (this.organization != null) {
            this.organization.wrapUp(root);
        }
        if (this.installation != null) {
            this.installation.wrapUp(root);
        }
    }

    public static class Status
    extends GHEventPayload {
        private String context;
        private String description;
        private GHCommitState state;
        private GHCommit commit;

        public String getContext() {
            return this.context;
        }

        public String getDescription() {
            return this.description;
        }

        public GHCommitState getState() {
            return this.state;
        }

        public void setState(GHCommitState state) {
            this.state = state;
        }

        public GHCommit getCommit() {
            return this.commit;
        }

        public void setCommit(GHCommit commit) {
            this.commit = commit;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.state == null) {
                throw new IllegalStateException("Expected status payload, but got something else. Maybe we've got another type of event?");
            }
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.commit.wrapUp(repository);
            }
        }
    }

    public static class Repository
    extends GHEventPayload {
    }

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", "NP_UNWRITTEN_FIELD"}, justification="Constructed by JSON deserialization")
    public static class Release
    extends GHEventPayload {
        private GHRelease release;

        public GHRelease getRelease() {
            return this.release;
        }

        public void setRelease(GHRelease release) {
            this.release = release;
        }
    }

    public static class Push
    extends GHEventPayload {
        private String head;
        private String before;
        private boolean created;
        private boolean deleted;
        private boolean forced;
        private String ref;
        private int size;
        private List<PushCommit> commits;
        private Pusher pusher;
        private String compare;

        public String getHead() {
            return this.head;
        }

        public String getBefore() {
            return this.before;
        }

        @JsonSetter
        private void setAfter(String after) {
            this.head = after;
        }

        public String getRef() {
            return this.ref;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isCreated() {
            return this.created;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean isForced() {
            return this.forced;
        }

        public List<PushCommit> getCommits() {
            return this.commits;
        }

        public Pusher getPusher() {
            return this.pusher;
        }

        public void setPusher(Pusher pusher) {
            this.pusher = pusher;
        }

        public String getCompare() {
            return this.compare;
        }

        public static class PushCommit {
            private GitUser author;
            private GitUser committer;
            private String url;
            private String sha;
            private String message;
            private boolean distinct;
            private List<String> added;
            private List<String> removed;
            private List<String> modified;

            public GitUser getAuthor() {
                return this.author;
            }

            public GitUser getCommitter() {
                return this.committer;
            }

            public String getUrl() {
                return this.url;
            }

            public String getSha() {
                return this.sha;
            }

            @JsonSetter
            private void setId(String id) {
                this.sha = id;
            }

            public String getMessage() {
                return this.message;
            }

            public boolean isDistinct() {
                return this.distinct;
            }

            public List<String> getAdded() {
                return this.added;
            }

            public List<String> getRemoved() {
                return this.removed;
            }

            public List<String> getModified() {
                return this.modified;
            }
        }

        public static class Pusher {
            private String name;
            private String email;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getEmail() {
                return this.email;
            }

            public void setEmail(String email) {
                this.email = email;
            }
        }
    }

    public static class Public
    extends GHEventPayload {
    }

    public static class Ping
    extends GHEventPayload {
    }

    public static class Fork
    extends GHEventPayload {
        private GHRepository forkee;

        public GHRepository getForkee() {
            return this.forkee;
        }

        public void setForkee(GHRepository forkee) {
            this.forkee = forkee;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            this.forkee.wrap(root);
        }
    }

    public static class DeploymentStatus
    extends GHEventPayload {
        private GHDeploymentStatus deploymentStatus;
        private GHDeployment deployment;

        public GHDeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public void setDeploymentStatus(GHDeploymentStatus deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public GHDeployment getDeployment() {
            return this.deployment;
        }

        public void setDeployment(GHDeployment deployment) {
            this.deployment = deployment;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.deployment.wrap(repository);
                this.deploymentStatus.wrap(repository);
            }
        }
    }

    public static class Deployment
    extends GHEventPayload {
        private GHDeployment deployment;

        public GHDeployment getDeployment() {
            return this.deployment;
        }

        public void setDeployment(GHDeployment deployment) {
            this.deployment = deployment;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.deployment.wrap(repository);
            }
        }
    }

    public static class Delete
    extends GHEventPayload {
        private String ref;
        private String refType;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRef() {
            return this.ref;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRefType() {
            return this.refType;
        }
    }

    public static class Create
    extends GHEventPayload {
        private String ref;
        private String refType;
        private String masterBranch;
        private String description;

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRef() {
            return this.ref;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getRefType() {
            return this.refType;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getMasterBranch() {
            return this.masterBranch;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Comes from JSON deserialization")
        public String getDescription() {
            return this.description;
        }
    }

    public static class CommitComment
    extends GHEventPayload {
        private GHCommitComment comment;

        public GHCommitComment getComment() {
            return this.comment;
        }

        public void setComment(GHCommitComment comment) {
            this.comment = comment;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.comment.wrap(repository);
            }
        }
    }

    public static class IssueComment
    extends GHEventPayload {
        private GHIssueComment comment;
        private GHIssue issue;

        public GHIssueComment getComment() {
            return this.comment;
        }

        public void setComment(GHIssueComment comment) {
            this.comment = comment;
        }

        public GHIssue getIssue() {
            return this.issue;
        }

        public void setIssue(GHIssue issue) {
            this.issue = issue;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.issue.wrap(repository);
            } else {
                this.issue.wrap(root);
            }
            this.comment.wrapUp(this.issue);
        }
    }

    public static class Issue
    extends GHEventPayload {
        private GHIssue issue;

        public GHIssue getIssue() {
            return this.issue;
        }

        public void setIssue(GHIssue issue) {
            this.issue = issue;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.issue.wrap(repository);
            } else {
                this.issue.wrap(root);
            }
        }
    }

    public static class PullRequestReviewComment
    extends GHEventPayload {
        private GHPullRequestReviewComment comment;
        private GHPullRequest pullRequest;

        public GHPullRequestReviewComment getComment() {
            return this.comment;
        }

        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.comment == null) {
                throw new IllegalStateException("Expected pull_request_review_comment payload, but got something else. Maybe we've got another type of event?");
            }
            this.comment.wrapUp(this.pullRequest);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            } else {
                this.pullRequest.wrapUp(root);
            }
        }
    }

    public static class PullRequestReview
    extends GHEventPayload {
        private GHPullRequestReview review;
        private GHPullRequest pullRequest;

        public GHPullRequestReview getReview() {
            return this.review;
        }

        public GHPullRequest getPullRequest() {
            return this.pullRequest;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.review == null) {
                throw new IllegalStateException("Expected pull_request_review payload, but got something else. Maybe we've got another type of event?");
            }
            this.review.wrapUp(this.pullRequest);
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            } else {
                this.pullRequest.wrapUp(root);
            }
        }
    }

    @SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest
    extends GHEventPayload {
        private int number;
        private GHPullRequest pullRequest;
        private GHLabel label;
        private GHPullRequestChanges changes;

        public int getNumber() {
            return this.number;
        }

        public GHPullRequest getPullRequest() {
            this.pullRequest.root = this.root;
            return this.pullRequest;
        }

        public GHLabel getLabel() {
            return this.label;
        }

        public GHPullRequestChanges getChanges() {
            return this.changes;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.pullRequest == null) {
                throw new IllegalStateException("Expected pull_request payload, but got something else. Maybe we've got another type of event?");
            }
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.pullRequest.wrapUp(repository);
            } else {
                this.pullRequest.wrapUp(root);
            }
        }
    }

    public static class InstallationRepositories
    extends GHEventPayload {
        private String repositorySelection;
        private List<GHRepository> repositoriesAdded;
        private List<GHRepository> repositoriesRemoved;

        public String getRepositorySelection() {
            return this.repositorySelection;
        }

        public List<GHRepository> getRepositoriesAdded() {
            return this.repositoriesAdded;
        }

        public List<GHRepository> getRepositoriesRemoved() {
            return this.repositoriesRemoved;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.getInstallation() == null) {
                throw new IllegalStateException("Expected check_suite payload, but got something else. Maybe we've got another type of event?");
            }
            List<GHRepository> repositories = "added".equals(this.getAction()) ? this.repositoriesAdded : this.repositoriesRemoved;
            if (repositories != null && !repositories.isEmpty()) {
                try {
                    for (GHRepository singleRepo : repositories) {
                        singleRepo.wrap(root);
                        singleRepo.populate();
                    }
                }
                catch (IOException e) {
                    throw new GHException("Failed to refresh repositories", e);
                }
            }
        }
    }

    public static class Installation
    extends GHEventPayload {
        private List<GHRepository> repositories;

        public List<GHRepository> getRepositories() {
            return this.repositories;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.getInstallation() == null) {
                throw new IllegalStateException("Expected check_suite payload, but got something else. Maybe we've got another type of event?");
            }
            if (this.repositories != null && !this.repositories.isEmpty()) {
                try {
                    for (GHRepository singleRepo : this.repositories) {
                        singleRepo.wrap(root);
                        singleRepo.populate();
                    }
                }
                catch (IOException e) {
                    throw new GHException("Failed to refresh repositories", e);
                }
            }
        }
    }

    public static class CheckSuite
    extends GHEventPayload {
        private GHCheckSuite checkSuite;

        public GHCheckSuite getCheckSuite() {
            return this.checkSuite;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.checkSuite == null) {
                throw new IllegalStateException("Expected check_suite payload, but got something else. Maybe we've got another type of event?");
            }
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.checkSuite.wrap(repository);
            } else {
                this.checkSuite.wrap(root);
            }
        }
    }

    public static class CheckRun
    extends GHEventPayload {
        private int number;
        private GHCheckRun checkRun;
        private GHRequestedAction requestedAction;

        public int getNumber() {
            return this.number;
        }

        public void setCheckRun(GHCheckRun currentCheckRun) {
            this.checkRun = currentCheckRun;
        }

        public GHCheckRun getCheckRun() {
            return this.checkRun;
        }

        public void setCheckRun(GHRequestedAction currentRequestedAction) {
            this.requestedAction = currentRequestedAction;
        }

        public GHRequestedAction getRequestedAction() {
            return this.requestedAction;
        }

        @Override
        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.checkRun == null) {
                throw new IllegalStateException("Expected check_run payload, but got something else. Maybe we've got another type of event?");
            }
            GHRepository repository = this.getRepository();
            if (repository != null) {
                this.checkRun.wrap(repository);
            } else {
                this.checkRun.wrap(root);
            }
        }
    }
}

