/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHCheckSuite;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHCheckRun
extends GHObject {
    GHRepository owner;
    GitHub root;
    private String status;
    private String conclusion;
    private String name;
    private String headSha;
    private String nodeId;
    private String externalId;
    private String startedAt;
    private String completedAt;
    private URL htmlUrl;
    private URL detailsUrl;
    private Output output;
    private GHApp app;
    private GHPullRequest[] pullRequests;
    private GHCheckSuite checkSuite;

    GHCheckRun wrap(GHRepository owner) {
        this.owner = owner;
        this.root = owner.root;
        return this;
    }

    GHCheckRun wrap(GitHub root) {
        this.root = root;
        if (this.owner != null) {
            this.owner.wrap(root);
        }
        return this;
    }

    GHPullRequest[] wrap() {
        return this.pullRequests;
    }

    public String getStatus() {
        return this.status;
    }

    public String getConclusion() {
        return this.conclusion;
    }

    public String getName() {
        return this.name;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    GHPullRequest[] getPullRequests() throws IOException {
        if (this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.refresh();
            }
        }
        return this.pullRequests;
    }

    @Override
    public URL getHtmlUrl() {
        return this.htmlUrl;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public URL getDetailsUrl() {
        return this.detailsUrl;
    }

    public Date getStartedAt() {
        return GitHubClient.parseDate(this.startedAt);
    }

    public Date getCompletedAt() {
        return GitHubClient.parseDate(this.completedAt);
    }

    public GHApp getApp() {
        return this.app;
    }

    public GHCheckSuite getCheckSuite() {
        return this.checkSuite;
    }

    public Output getOutput() {
        return this.output;
    }

    public static enum AnnotationLevel {
        NOTICE,
        WARNING,
        FAILURE;

    }

    public static class Output {
        private String title;
        private String summary;
        private String text;
        private int annotationsCount;
        private URL annotationsUrl;

        public String getTitle() {
            return this.title;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getText() {
            return this.text;
        }

        public int getAnnotationsCount() {
            return this.annotationsCount;
        }

        public URL getAnnotationsUrl() {
            return this.annotationsUrl;
        }
    }

    public static enum Conclusion {
        SUCCESS,
        FAILURE,
        NEUTRAL,
        CANCELLED,
        TIMED_OUT,
        ACTION_REQUIRED,
        SKIPPED;

    }

    public static enum Status {
        QUEUED,
        IN_PROGRESS,
        COMPLETED;

    }
}

