/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHProjectColumn;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHProject
extends GHObject {
    protected GitHub root;
    protected GHObject owner;
    private String owner_url;
    private String html_url;
    private String name;
    private String body;
    private int number;
    private String state;
    private GHUser creator;

    @Override
    public URL getHtmlUrl() throws IOException {
        return GitHubClient.parseURL(this.html_url);
    }

    public GitHub getRoot() {
        return this.root;
    }

    public GHObject getOwner() throws IOException {
        if (this.owner == null) {
            try {
                if (this.owner_url.contains("/orgs/")) {
                    this.owner = ((Requester)this.root.createRequest().withUrlPath(this.getOwnerUrl().getPath(), new String[0])).fetch(GHOrganization.class).wrapUp(this.root);
                } else if (this.owner_url.contains("/users/")) {
                    this.owner = ((Requester)this.root.createRequest().withUrlPath(this.getOwnerUrl().getPath(), new String[0])).fetch(GHUser.class).wrapUp(this.root);
                } else if (this.owner_url.contains("/repos/")) {
                    this.owner = ((Requester)this.root.createRequest().withUrlPath(this.getOwnerUrl().getPath(), new String[0])).fetch(GHRepository.class).wrap(this.root);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.owner;
    }

    public URL getOwnerUrl() {
        return GitHubClient.parseURL(this.owner_url);
    }

    @Deprecated
    public String getNode_id() {
        return this.getNodeId();
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    public ProjectState getState() {
        return Enum.valueOf(ProjectState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public GHUser getCreator() {
        return this.creator;
    }

    public GHProject wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }

    public GHProject wrap(GitHub root) {
        this.root = root;
        return this;
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).withPreview("application/vnd.github.inertia-preview+json")).with(key, value)).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    protected String getApiRoute() {
        return "/projects/" + this.getId();
    }

    public void setName(String name) throws IOException {
        this.edit("name", name);
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void setState(ProjectState state) throws IOException {
        this.edit("state", state.toString().toLowerCase());
    }

    public void setOrganizationPermission(GHPermissionType permission) throws IOException {
        this.edit("organization_permission", permission.toString().toLowerCase());
    }

    public void setPublic(boolean isPublic) throws IOException {
        this.edit("public", isPublic);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.inertia-preview+json")).method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public PagedIterable<GHProjectColumn> listColumns() throws IOException {
        GHProject project = this;
        return ((Requester)((Requester)this.root.createRequest().withPreview("application/vnd.github.inertia-preview+json")).withUrlPath(String.format("/projects/%d/columns", this.getId()), new String[0])).toIterable(GHProjectColumn[].class, item -> item.wrap(project));
    }

    public GHProjectColumn createColumn(String name) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("POST")).withPreview("application/vnd.github.inertia-preview+json")).with("name", name)).withUrlPath(String.format("/projects/%d/columns", this.getId()), new String[0])).fetch(GHProjectColumn.class).wrap(this);
    }

    public static enum ProjectStateFilter {
        ALL,
        OPEN,
        CLOSED;

    }

    public static enum ProjectState {
        OPEN,
        CLOSED;

    }
}

