/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;

public class GHTeam
implements Refreshable {
    private String name;
    private String permission;
    private String slug;
    private String description;
    private Privacy privacy;
    private int id;
    private GHOrganization organization;
    protected GitHub root;

    GHTeam wrapUp(GHOrganization owner) {
        this.organization = owner;
        this.root = owner.root;
        return this;
    }

    GHTeam wrapUp(GitHub root) {
        this.organization.wrapUp(root);
        return this.wrapUp(this.organization);
    }

    static GHTeam[] wrapUp(GHTeam[] teams, GHPullRequest owner) {
        for (GHTeam t : teams) {
            t.root = owner.root;
        }
        return teams;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getDescription() {
        return this.description;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public void setDescription(String description) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).with("description", description)).withUrlPath(this.api(""))).send();
    }

    public void setPrivacy(Privacy privacy) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).with("privacy", privacy)).withUrlPath(this.api(""))).send();
    }

    public int getId() {
        return this.id;
    }

    public PagedIterable<GHUser> listMembers() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.api("/members"))).toIterable(GHUser[].class, item -> item.wrapUp(this.root));
    }

    public Set<GHUser> getMembers() throws IOException {
        return this.listMembers().toSet();
    }

    public boolean hasMember(GHUser user) {
        try {
            ((Requester)this.root.createRequest().withUrlPath("/teams/" + this.id + "/members/" + user.getLogin())).send();
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        TreeMap<String, GHRepository> m = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories()) {
            m.put(r.getName(), r);
        }
        return m;
    }

    public PagedIterable<GHRepository> listRepositories() {
        return ((Requester)this.root.createRequest().withUrlPath(this.api("/repos"))).toIterable(GHRepository[].class, item -> item.wrap(this.root));
    }

    public void add(GHUser u) throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.api("/memberships/" + u.getLogin()))).send();
    }

    public void add(GHUser user, Role role) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("role", role)).withUrlPath(this.api("/memberships/" + user.getLogin()))).send();
    }

    public void remove(GHUser u) throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.api("/members/" + u.getLogin()))).send();
    }

    public void add(GHRepository r) throws IOException {
        this.add(r, null);
    }

    public void add(GHRepository r, GHOrganization.Permission permission) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("permission", permission)).withUrlPath(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()))).send();
    }

    public void remove(GHRepository r) throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()))).send();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.api(""))).send();
    }

    private String api(String tail) {
        return "/teams/" + this.id + tail;
    }

    public GHOrganization getOrganization() throws IOException {
        this.refresh(this.organization);
        return this.organization;
    }

    @Override
    public void refresh() throws IOException {
        ((Requester)this.root.createRequest().withUrlPath(this.api(""))).fetchInto(this).wrapUp(this.root);
    }

    public static enum Role {
        MEMBER,
        MAINTAINER;

    }

    public static enum Privacy {
        SECRET,
        CLOSED;

    }
}

