/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.Requester;

public class GHGistUpdater {
    private final GHGist base;
    private final Requester builder;
    LinkedHashMap<String, Object> files;

    GHGistUpdater(GHGist base) {
        this.base = base;
        this.builder = base.root.createRequest();
        this.files = new LinkedHashMap();
    }

    public GHGistUpdater addFile(String fileName, String content) throws IOException {
        this.updateFile(fileName, content);
        return this;
    }

    public GHGistUpdater renameFile(String fileName, String newFileName) throws IOException {
        this.files.put(fileName, Collections.singletonMap("filename", newFileName));
        return this;
    }

    public GHGistUpdater updateFile(String fileName, String content) throws IOException {
        this.files.put(fileName, Collections.singletonMap("content", content));
        return this;
    }

    public GHGistUpdater description(String desc) {
        this.builder.with("description", desc);
        return this;
    }

    public GHGist update() throws IOException {
        this.builder.with("files", this.files);
        return ((Requester)((Requester)this.builder.method("PATCH")).withUrlPath(this.base.getApiTailUrl(""))).fetch(GHGist.class);
    }
}

