/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.PagedIterable;

class Requester
extends GitHubRequest.Builder<Requester> {
    final GitHubClient client;

    Requester(GitHubClient client) {
        this.client = client;
        this.withApiUrl(client.getApiUrl());
    }

    public void send() throws IOException {
        this.client.sendRequest(this, responseInfo -> responseInfo.getBodyAsString());
    }

    public <T> T fetch(@Nonnull Class<T> type) throws IOException {
        return (T)this.client.sendRequest(this, responseInfo -> GitHubResponse.parseBody(responseInfo, type)).body();
    }

    public <T> T[] fetchArray(@Nonnull Class<T[]> type) throws IOException {
        return this.toIterable(this.client, type, null).toArray();
    }

    public <T> T fetchInto(@Nonnull T existingInstance) throws IOException {
        return (T)this.client.sendRequest(this, responseInfo -> GitHubResponse.parseBody(responseInfo, existingInstance)).body();
    }

    public int fetchHttpStatusCode() throws IOException {
        return this.client.sendRequest(this.build(), null).statusCode();
    }

    public InputStream fetchStream() throws IOException {
        return this.client.sendRequest(this, responseInfo -> responseInfo.bodyStream()).body();
    }

    public <R> PagedIterable<R> toIterable(Class<R[]> type, Consumer<R> itemInitializer) {
        return this.toIterable(this.client, type, itemInitializer);
    }
}

