/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class PagedIterator<T>
implements Iterator<T> {
    protected final Iterator<T[]> base;
    private T[] currentPage;
    private int nextItemIndex;

    PagedIterator(Iterator<T[]> base) {
        this.base = base;
    }

    protected abstract void wrapUp(T[] var1);

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.currentPage.length > this.nextItemIndex;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentPage[this.nextItemIndex++];
    }

    private void fetch() {
        if ((this.currentPage == null || this.currentPage.length <= this.nextItemIndex) && this.base.hasNext()) {
            T[] result = Objects.requireNonNull(this.base.next());
            this.wrapUp(result);
            this.currentPage = result;
            this.nextItemIndex = 0;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<T> nextPage() {
        return Arrays.asList(this.nextPageArray());
    }

    @Nonnull
    T[] nextPageArray() {
        if (this.currentPage == null) {
            this.fetch();
        } else if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Objects.requireNonNull(this.currentPage);
        T[] r = this.currentPage;
        if (this.nextItemIndex != 0) {
            r = Arrays.copyOfRange(r, this.nextItemIndex, r.length);
        }
        this.nextItemIndex = this.currentPage.length;
        return r;
    }
}

