/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubPageContentsIterable;
import org.kohsuke.github.PagedIterable;

class GitHubRequest {
    private static final List<String> METHODS_WITHOUT_BODY = Arrays.asList("GET", "DELETE");
    private final List<Entry> args;
    private final Map<String, String> headers;
    private final String apiUrl;
    private final String urlPath;
    private final String method;
    private final InputStream body;
    private final boolean forceBody;
    private final URL url;

    private GitHubRequest(@Nonnull List<Entry> args, @Nonnull Map<String, String> headers, @Nonnull String apiUrl, @Nonnull String urlPath, @Nonnull String method, @CheckForNull InputStream body, boolean forceBody) throws MalformedURLException {
        this.args = Collections.unmodifiableList(new ArrayList<Entry>(args));
        this.headers = Collections.unmodifiableMap(new LinkedHashMap<String, String>(headers));
        this.apiUrl = apiUrl;
        this.urlPath = urlPath;
        this.method = method;
        this.body = body;
        this.forceBody = forceBody;
        String tailApiUrl = this.buildTailApiUrl();
        this.url = GitHubRequest.getApiURL(apiUrl, tailApiUrl);
    }

    public static Builder<?> newBuilder() {
        return new Builder();
    }

    @Nonnull
    static URL getApiURL(String apiUrl, String tailApiUrl) throws MalformedURLException {
        if (tailApiUrl.startsWith("/")) {
            if ("github.com".equals(apiUrl)) {
                return new URL("https://api.github.com" + tailApiUrl);
            }
            return new URL(apiUrl + tailApiUrl);
        }
        return new URL(tailApiUrl);
    }

    static String transformEnum(Enum<?> en) {
        return en.toString().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    @Nonnull
    public String method() {
        return this.method;
    }

    @Nonnull
    public List<Entry> args() {
        return this.args;
    }

    @Nonnull
    public Map<String, String> headers() {
        return this.headers;
    }

    @Nonnull
    public String apiUrl() {
        return this.apiUrl;
    }

    @Nonnull
    public String urlPath() {
        return this.urlPath;
    }

    @Nonnull
    public String contentType() {
        return this.headers.get("Content-type");
    }

    @CheckForNull
    public InputStream body() {
        return this.body;
    }

    @Nonnull
    public URL url() {
        return this.url;
    }

    public boolean inBody() {
        return this.forceBody || !METHODS_WITHOUT_BODY.contains(this.method);
    }

    public Builder<?> toBuilder() {
        return new Builder(this.args, this.headers, this.apiUrl, this.urlPath, this.method, this.body, this.forceBody);
    }

    private String buildTailApiUrl() {
        String tailApiUrl = this.urlPath;
        if (!this.inBody() && !this.args.isEmpty() && tailApiUrl.startsWith("/")) {
            try {
                StringBuilder argString = new StringBuilder();
                boolean questionMarkFound = tailApiUrl.indexOf(63) != -1;
                argString.append(questionMarkFound ? (char)'&' : '?');
                ListIterator<Entry> it = this.args.listIterator();
                while (it.hasNext()) {
                    Entry arg = (Entry)it.next();
                    argString.append(URLEncoder.encode(arg.key, StandardCharsets.UTF_8.name()));
                    argString.append('=');
                    argString.append(URLEncoder.encode(arg.value.toString(), StandardCharsets.UTF_8.name()));
                    if (!it.hasNext()) continue;
                    argString.append('&');
                }
                tailApiUrl = tailApiUrl + argString;
            }
            catch (UnsupportedEncodingException e) {
                throw new GHException("UTF-8 encoding required", e);
            }
        }
        return tailApiUrl;
    }

    private static String urlPathEncode(String value) {
        try {
            return new URI(null, null, value, null, null).toString();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected static class Entry {
        final String key;
        final Object value;

        protected Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    static class Builder<B extends Builder<B>> {
        @Nonnull
        private final List<Entry> args;
        @Nonnull
        private final Map<String, String> headers;
        @Nonnull
        private String apiUrl;
        @Nonnull
        private String urlPath;
        @Nonnull
        private String method;
        private InputStream body;
        private boolean forceBody;

        protected Builder() {
            this(new ArrayList<Entry>(), new LinkedHashMap<String, String>(), "https://api.github.com", "/", "GET", null, false);
        }

        private Builder(@Nonnull List<Entry> args, @Nonnull Map<String, String> headers, @Nonnull String apiUrl, @Nonnull String urlPath, @Nonnull String method, @CheckForNull @WillClose InputStream body, boolean forceBody) {
            this.args = new ArrayList<Entry>(args);
            this.headers = new LinkedHashMap<String, String>(headers);
            this.apiUrl = apiUrl;
            this.urlPath = urlPath;
            this.method = method;
            this.body = body;
            this.forceBody = forceBody;
        }

        public GitHubRequest build() throws MalformedURLException {
            return new GitHubRequest(this.args, this.headers, this.apiUrl, this.urlPath, this.method, this.body, this.forceBody);
        }

        public <R> PagedIterable<R> toIterable(GitHubClient client, Class<R[]> type, Consumer<R> itemInitializer) {
            try {
                return new GitHubPageContentsIterable<R>(client, this.build(), type, itemInitializer);
            }
            catch (MalformedURLException e) {
                throw new GHException(e.getMessage(), e);
            }
        }

        public B withApiUrl(String url) {
            this.apiUrl = url;
            return (B)this;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public B withHeader(String name, String value) {
            this.setHeader(name, value);
            return (B)this;
        }

        public B withPreview(String name) {
            return this.withHeader("Accept", name);
        }

        public B with(String key, int value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, long value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, boolean value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Enum<?> e) {
            if (e == null) {
                return this.with(key, (Object)null);
            }
            return this.with(key, GitHubRequest.transformEnum(e));
        }

        public B with(String key, String value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Collection<?> value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Map<?, ?> value) {
            return this.with(key, (Object)value);
        }

        public B with(@WillClose InputStream body) {
            this.body = body;
            return (B)this;
        }

        public B withNullable(String key, Object value) {
            this.args.add(new Entry(key, value));
            return (B)this;
        }

        public B with(String key, Object value) {
            if (value != null) {
                this.args.add(new Entry(key, value));
            }
            return (B)this;
        }

        public B set(String key, Object value) {
            for (int index = 0; index < this.args.size(); ++index) {
                if (!this.args.get((int)index).key.equals(key)) continue;
                this.args.set(index, new Entry(key, value));
                return (B)this;
            }
            return this.with(key, value);
        }

        public B method(@Nonnull String method) {
            this.method = method;
            return (B)this;
        }

        public B contentType(String contentType) {
            this.headers.put("Content-type", contentType);
            return (B)this;
        }

        B setRawUrlPath(String urlOrPath) {
            Objects.requireNonNull(urlOrPath);
            this.urlPath = urlOrPath;
            return (B)this;
        }

        public B withUrlPath(String ... urlPathItems) {
            if (urlPathItems.length == 1 && !urlPathItems[0].startsWith("/")) {
                return this.setRawUrlPath(urlPathItems[0]);
            }
            if (!this.urlPath.startsWith("/")) {
                throw new GHException("Cannot append to url path after setting a full url");
            }
            String tailUrlPath = String.join((CharSequence)"/", urlPathItems);
            tailUrlPath = this.urlPath.endsWith("/") ? StringUtils.stripStart((String)tailUrlPath, (String)"/") : StringUtils.prependIfMissing((String)tailUrlPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            this.urlPath = this.urlPath + GitHubRequest.urlPathEncode(tailUrlPath);
            return (B)this;
        }

        public B inBody() {
            this.forceBody = true;
            return (B)this;
        }

        public B withPageSize(int pageSize) {
            if (pageSize > 0) {
                this.with("per_page", pageSize);
            }
            return (B)this;
        }
    }
}

