/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

class GitHubPageContentsIterable<T>
extends PagedIterable<T> {
    private final GitHubClient client;
    private final GitHubRequest request;
    private final Class<T[]> clazz;
    private final Consumer<T> itemInitializer;

    GitHubPageContentsIterable(GitHubClient client, GitHubRequest request, Class<T[]> clazz, Consumer<T> itemInitializer) {
        this.client = client;
        this.request = request;
        this.clazz = clazz;
        this.itemInitializer = itemInitializer;
    }

    @Override
    @Nonnull
    public PagedIterator<T> _iterator(int pageSize) {
        GitHubPageIterator<T[]> iterator = GitHubPageIterator.create(this.client, this.clazz, this.request.toBuilder().withPageSize(pageSize));
        return new GitHubPageContentsIterator(iterator);
    }

    @Nonnull
    GitHubResponse<T[]> toResponse() throws IOException {
        GitHubPageContentsIterator iterator = (GitHubPageContentsIterator)this.iterator();
        T[] items = this.toArray(iterator);
        GitHubResponse lastResponse = iterator.lastResponse();
        return new GitHubResponse<T[]>(lastResponse, items);
    }

    private class GitHubPageContentsIterator
    extends PagedIterator<T> {
        public GitHubPageContentsIterator(GitHubPageIterator<T[]> iterator) {
            super(iterator);
        }

        @Override
        protected void wrapUp(T[] page) {
            if (GitHubPageContentsIterable.this.itemInitializer != null) {
                for (Object item : page) {
                    GitHubPageContentsIterable.this.itemInitializer.accept(item);
                }
            }
        }

        private GitHubResponse<T[]> lastResponse() {
            return ((GitHubPageIterator)this.base).finalResponse();
        }
    }
}

