/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOTPRequiredException;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubRateLimitChecker;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.RateLimitHandler;

abstract class GitHubClient {
    static final int CONNECTION_ERROR_RETRIES = 2;
    static final int retryTimeoutMillis = 100;
    final String login;
    final String encodedAuthorization;
    private final String apiUrl;
    protected final RateLimitHandler rateLimitHandler;
    protected final AbuseLimitHandler abuseLimitHandler;
    private final GitHubRateLimitChecker rateLimitChecker;
    private HttpConnector connector;
    private final Object headerRateLimitLock = new Object();
    private GHRateLimit headerRateLimit = null;
    private volatile GHRateLimit rateLimit = null;
    private static final Logger LOGGER = Logger.getLogger(GitHubClient.class.getName());
    static final ObjectMapper MAPPER = new ObjectMapper();
    static final String GITHUB_URL = "https://api.github.com";
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.S'Z'"};

    GitHubClient(String apiUrl, String login, String oauthAccessToken, String jwtToken, String password, HttpConnector connector, RateLimitHandler rateLimitHandler, AbuseLimitHandler abuseLimitHandler, GitHubRateLimitChecker rateLimitChecker, Consumer<GHMyself> myselfConsumer) throws IOException {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        if (null == connector) {
            connector = HttpConnector.DEFAULT;
        }
        this.apiUrl = apiUrl;
        this.connector = connector;
        if (oauthAccessToken != null) {
            this.encodedAuthorization = "token " + oauthAccessToken;
        } else if (jwtToken != null) {
            this.encodedAuthorization = "Bearer " + jwtToken;
        } else if (password != null) {
            String authorization = login + ':' + password;
            String charsetName = StandardCharsets.UTF_8.name();
            this.encodedAuthorization = "Basic " + Base64.getEncoder().encodeToString(authorization.getBytes(charsetName));
        } else {
            this.encodedAuthorization = null;
        }
        this.rateLimitHandler = rateLimitHandler;
        this.abuseLimitHandler = abuseLimitHandler;
        this.rateLimitChecker = rateLimitChecker;
        if (login == null && this.encodedAuthorization != null && jwtToken == null) {
            GHMyself myself = this.fetch(GHMyself.class, "/user");
            login = myself.getLogin();
            if (myselfConsumer != null) {
                myselfConsumer.accept(myself);
            }
        }
        this.login = login;
    }

    private <T> T fetch(Class<T> type, String urlPath) throws IOException {
        return (T)this.sendRequest(((GitHubRequest.Builder)((GitHubRequest.Builder)GitHubRequest.newBuilder().withApiUrl(this.getApiUrl())).withUrlPath(urlPath)).build(), (GitHubResponse.ResponseInfo responseInfo) -> GitHubResponse.parseBody(responseInfo, type)).body();
    }

    public boolean isCredentialValid() {
        try {
            this.fetch(GHUser.class, "/user");
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Exception validating credentials on " + this.getApiUrl() + " with login '" + this.login + "' " + e, e);
            }
            return false;
        }
    }

    public boolean isOffline() {
        return this.getConnector() == HttpConnector.OFFLINE;
    }

    public HttpConnector getConnector() {
        return this.connector;
    }

    @Deprecated
    public void setConnector(HttpConnector connector) {
        LOGGER.warning("Connector should not be changed. Please file an issue describing your use case.");
        this.connector = connector;
    }

    public boolean isAnonymous() {
        return this.login == null && this.encodedAuthorization == null;
    }

    public GHRateLimit getRateLimit() throws IOException {
        GHRateLimit rateLimit;
        try {
            rateLimit = this.fetch(JsonRateLimit.class, (String)"/rate_limit").resources;
        }
        catch (FileNotFoundException e) {
            rateLimit = GHRateLimit.Unknown();
        }
        this.rateLimit = rateLimit;
        return this.rateLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public GHRateLimit lastRateLimit() {
        Object object = this.headerRateLimitLock;
        synchronized (object) {
            return this.headerRateLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public GHRateLimit rateLimit() throws IOException {
        Object object = this.headerRateLimitLock;
        synchronized (object) {
            if (this.headerRateLimit != null && !this.headerRateLimit.isExpired()) {
                return this.headerRateLimit;
            }
        }
        GHRateLimit rateLimit = this.rateLimit;
        if (rateLimit == null || rateLimit.isExpired()) {
            rateLimit = this.getRateLimit();
        }
        return rateLimit;
    }

    public void checkApiUrlValidity() throws IOException {
        try {
            this.fetch(GHApiInfo.class, "/").check(this.getApiUrl());
        }
        catch (IOException e) {
            if (this.isPrivateModeEnabled()) {
                throw (IOException)new IOException("GitHub Enterprise server (" + this.getApiUrl() + ") with private mode enabled").initCause(e);
            }
            throw e;
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @Nonnull
    public <T> GitHubResponse<T> sendRequest(@Nonnull GitHubRequest.Builder<?> builder, @CheckForNull GitHubResponse.BodyHandler<T> handler) throws IOException {
        return this.sendRequest(builder.build(), handler);
    }

    @Nonnull
    public <T> GitHubResponse<T> sendRequest(GitHubRequest request, @CheckForNull GitHubResponse.BodyHandler<T> handler) throws IOException {
        int retries = 2;
        do {
            GitHubResponse.ResponseInfo responseInfo = null;
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "GitHub API request [" + (this.login == null ? "anonymous" : this.login) + "]: " + request.method() + " " + request.url().toString());
                }
                this.rateLimitChecker.checkRateLimit(this, request);
                responseInfo = this.getResponseInfo(request);
                this.noteRateLimit(responseInfo);
                GitHubClient.detectOTPRequired(responseInfo);
                if (GitHubClient.isInvalidCached404Response(responseInfo)) {
                    request = ((GitHubRequest.Builder)request.toBuilder().withHeader("Cache-Control", "no-cache")).build();
                    continue;
                }
                if (!GitHubClient.isRateLimitResponse(responseInfo) && !GitHubClient.isAbuseLimitResponse(responseInfo)) {
                    return GitHubClient.createResponse(responseInfo, handler);
                }
            }
            catch (IOException e) {
                if (GitHubClient.retryConnectionError(e, request.url(), retries)) continue;
                throw GitHubClient.interpretApiError(e, request, responseInfo);
            }
            this.handleLimitingErrors(responseInfo);
        } while (--retries >= 0);
        throw new GHIOException("Ran out of retries for URL: " + request.url().toString());
    }

    @Nonnull
    protected abstract GitHubResponse.ResponseInfo getResponseInfo(GitHubRequest var1) throws IOException;

    protected abstract void handleLimitingErrors(@Nonnull GitHubResponse.ResponseInfo var1) throws IOException;

    @Nonnull
    private static <T> GitHubResponse<T> createResponse(@Nonnull GitHubResponse.ResponseInfo responseInfo, @CheckForNull GitHubResponse.BodyHandler<T> handler) throws IOException {
        T body = null;
        if (responseInfo.statusCode() != 304) {
            if (responseInfo.statusCode() == 202) {
                if (responseInfo.url().toString().endsWith("/forks")) {
                    LOGGER.log(Level.INFO, "The fork is being created. Please try again in 5 seconds.");
                } else if (responseInfo.url().toString().endsWith("/statistics")) {
                    LOGGER.log(Level.INFO, "The statistics are being generated. Please try again in 5 seconds.");
                } else {
                    LOGGER.log(Level.INFO, "Received 202 from " + responseInfo.url().toString() + " . Please try again in 5 seconds.");
                }
            } else if (handler != null) {
                body = handler.apply(responseInfo);
                GitHubClient.setResponseHeaders(responseInfo, body);
            }
        }
        return new GitHubResponse<Object>(responseInfo, body);
    }

    private static IOException interpretApiError(IOException e, @Nonnull GitHubRequest request, @CheckForNull GitHubResponse.ResponseInfo responseInfo) throws IOException {
        if (e instanceof GHIOException) {
            return e;
        }
        int statusCode = -1;
        String message = null;
        HashMap<String, List<String>> headers = new HashMap();
        String errorMessage = null;
        if (responseInfo != null) {
            statusCode = responseInfo.statusCode();
            message = responseInfo.headerField("Status");
            headers = responseInfo.headers();
            errorMessage = responseInfo.errorMessage();
        }
        if (errorMessage != null) {
            e = e instanceof FileNotFoundException ? new GHFileNotFoundException(e.getMessage() + " " + errorMessage, e).withResponseHeaderFields(headers) : (statusCode >= 0 ? new HttpException(errorMessage, statusCode, message, request.url().toString(), e) : new GHIOException(errorMessage).withResponseHeaderFields(headers));
        } else if (!(e instanceof FileNotFoundException)) {
            e = new HttpException(statusCode, message, request.url().toString(), (Throwable)e);
        }
        return e;
    }

    private static <T> void setResponseHeaders(GitHubResponse.ResponseInfo responseInfo, T readValue) {
        if (readValue instanceof GHObject[]) {
            for (GHObject ghObject : (GHObject[])readValue) {
                ghObject.responseHeaderFields = responseInfo.headers();
            }
        } else if (readValue instanceof GHObject) {
            ((GHObject)readValue).responseHeaderFields = responseInfo.headers();
        } else if (readValue instanceof JsonRateLimit) {
            ((JsonRateLimit)readValue).resources.getCore().recalculateResetDate(responseInfo.headerField("Date"));
        }
    }

    protected static boolean isRateLimitResponse(@Nonnull GitHubResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() == 403 && "0".equals(responseInfo.headerField("X-RateLimit-Remaining"));
    }

    protected static boolean isAbuseLimitResponse(@Nonnull GitHubResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() == 403 && responseInfo.headerField("Retry-After") != null;
    }

    private static boolean retryConnectionError(IOException e, URL url, int retries) throws IOException {
        boolean connectionError;
        boolean bl = connectionError = e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof SSLHandshakeException;
        if (connectionError && retries > 0) {
            LOGGER.log(Level.INFO, e.getMessage() + " while connecting to " + url + ". Sleeping " + 100 + " milliseconds before retrying... ; will try " + retries + " more time(s)");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
            return true;
        }
        return false;
    }

    private static boolean isInvalidCached404Response(GitHubResponse.ResponseInfo responseInfo) {
        if (responseInfo.statusCode() == 404 && Objects.equals(responseInfo.request().method(), "GET") && responseInfo.headerField("ETag") != null && !Objects.equals(responseInfo.request().headers().get("Cache-Control"), "no-cache")) {
            LOGGER.log(Level.FINE, "Encountered GitHub invalid cached 404 from " + responseInfo.url() + ". Retrying with \"Cache-Control\"=\"no-cache\"...");
            return true;
        }
        return false;
    }

    private void noteRateLimit(@Nonnull GitHubResponse.ResponseInfo responseInfo) {
        long reset;
        int remaining;
        int limit;
        if (responseInfo.request().urlPath().startsWith("/search")) {
            return;
        }
        String limitString = responseInfo.headerField("X-RateLimit-Limit");
        if (StringUtils.isBlank((CharSequence)limitString)) {
            return;
        }
        String remainingString = responseInfo.headerField("X-RateLimit-Remaining");
        if (StringUtils.isBlank((CharSequence)remainingString)) {
            return;
        }
        String resetString = responseInfo.headerField("X-RateLimit-Reset");
        if (StringUtils.isBlank((CharSequence)resetString)) {
            return;
        }
        try {
            limit = Integer.parseInt(limitString);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Limit header value " + limitString, e);
            }
            return;
        }
        try {
            remaining = Integer.parseInt(remainingString);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Remaining header value " + remainingString, e);
            }
            return;
        }
        try {
            reset = Long.parseLong(resetString);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Reset header value " + resetString, e);
            }
            return;
        }
        GHRateLimit.Record observed = new GHRateLimit.Record(limit, remaining, reset, responseInfo.headerField("Date"));
        this.updateCoreRateLimit(observed);
    }

    private static void detectOTPRequired(@Nonnull GitHubResponse.ResponseInfo responseInfo) throws GHIOException {
        if (responseInfo.statusCode() == 401 && responseInfo.headerField("X-GitHub-OTP") != null) {
            throw new GHOTPRequiredException().withResponseHeaderFields(responseInfo.headers());
        }
    }

    void requireCredential() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCoreRateLimit(@Nonnull GHRateLimit.Record observed) {
        Object object = this.headerRateLimitLock;
        synchronized (object) {
            if (this.headerRateLimit == null || GitHubClient.shouldReplace(observed, this.headerRateLimit.getCore())) {
                this.headerRateLimit = GHRateLimit.fromHeaderRecord(observed);
                LOGGER.log(Level.FINE, "Rate limit now: {0}", this.headerRateLimit);
            }
        }
    }

    private boolean isPrivateModeEnabled() {
        try {
            GitHubResponse response = this.sendRequest((GitHubRequest.Builder<?>)GitHubRequest.newBuilder().withApiUrl(this.getApiUrl()), null);
            return response.statusCode() == 401 && response.headerField("X-GitHub-Media-Type") != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    static boolean shouldReplace(@Nonnull GHRateLimit.Record candidate, @Nonnull GHRateLimit.Record current) {
        if (candidate instanceof GHRateLimit.UnknownLimitRecord && !(current instanceof GHRateLimit.UnknownLimitRecord)) {
            return false;
        }
        if (current instanceof GHRateLimit.UnknownLimitRecord && !(candidate instanceof GHRateLimit.UnknownLimitRecord)) {
            return true;
        }
        return current.getResetEpochSeconds() < candidate.getResetEpochSeconds() || current.getResetEpochSeconds() == candidate.getResetEpochSeconds() && current.getRemaining() > candidate.getRemaining();
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static String printDate(Date dt) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(dt);
    }

    static {
        MAPPER.setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true);
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    private static class GHApiInfo {
        private String rate_limit_url;

        private GHApiInfo() {
        }

        void check(String apiUrl) throws IOException {
            if (this.rate_limit_url == null) {
                throw new IOException(apiUrl + " doesn't look like GitHub API URL");
            }
            new URL(this.rate_limit_url);
        }
    }
}

