/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.SearchResult;

public abstract class GHSearchBuilder<T>
extends GHQueryBuilder<T> {
    protected final List<String> terms = new ArrayList<String>();
    private final Class<? extends SearchResult<T>> receiverType;

    GHSearchBuilder(GitHub root, Class<? extends SearchResult<T>> receiverType) {
        super(root);
        this.receiverType = receiverType;
    }

    public GHQueryBuilder<T> q(String term) {
        this.terms.add(term);
        return this;
    }

    @Override
    public PagedSearchIterable<T> list() {
        this.req.set("q", StringUtils.join(this.terms, (String)" "));
        try {
            final GitHubRequest baseRequest = this.req.build();
            return new PagedSearchIterable<T>(this.root){

                @Override
                @Nonnull
                public PagedIterator<T> _iterator(int pageSize) {
                    return new PagedIterator<T>(this.adapt(GitHubPageIterator.create(GHSearchBuilder.this.root.getClient(), GHSearchBuilder.this.receiverType, ((GitHubRequest.Builder)baseRequest.toBuilder().withUrlPath(GHSearchBuilder.this.getApiUrl())).withPageSize(pageSize)))){

                        @Override
                        protected void wrapUp(T[] page) {
                        }
                    };
                }
            };
        }
        catch (MalformedURLException e) {
            throw new GHException("", e);
        }
    }

    protected abstract String getApiUrl();
}

