/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.kohsuke.github.GHGist;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHGistBuilder {
    private final GitHub root;
    private final Requester req;
    private final LinkedHashMap<String, Object> files = new LinkedHashMap();

    public GHGistBuilder(GitHub root) {
        this.root = root;
        this.req = (Requester)root.createRequest().method("POST");
    }

    public GHGistBuilder description(String desc) {
        this.req.with("description", desc);
        return this;
    }

    public GHGistBuilder public_(boolean v) {
        this.req.with("public", v);
        return this;
    }

    public GHGistBuilder file(String fileName, String content) {
        this.files.put(fileName, Collections.singletonMap("content", content));
        return this;
    }

    public GHGist create() throws IOException {
        this.req.with("files", this.files);
        return ((Requester)this.req.withUrlPath("/gists")).fetch(GHGist.class).wrapUp(this.root);
    }
}

