/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.GHOTPRequiredException;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

class Requester {
    private final GitHub root;
    private final List<Entry> args = new ArrayList<Entry>();
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    @Nonnull
    private String urlPath = "/";
    private String method = "GET";
    private String contentType = null;
    private InputStream body;
    private HttpURLConnection uc;
    private boolean forceBody;
    private static final List<String> METHODS_WITHOUT_BODY = Arrays.asList("GET", "DELETE");
    private static final Logger LOGGER = Logger.getLogger(Requester.class.getName());

    Requester(GitHub root) {
        this.root = root;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Requester withHeader(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public Requester withPreview(String name) {
        return this.withHeader("Accept", name);
    }

    public Requester with(String key, int value) {
        return this.with(key, (Object)value);
    }

    public Requester with(String key, long value) {
        return this.with(key, (Object)value);
    }

    public Requester with(String key, boolean value) {
        return this.with(key, (Object)value);
    }

    public Requester with(String key, Enum e) {
        if (e == null) {
            return this.with(key, (Object)null);
        }
        return this.with(key, Requester.transformEnum(e));
    }

    public Requester with(String key, String value) {
        return this.with(key, (Object)value);
    }

    public Requester with(String key, Collection<?> value) {
        return this.with(key, (Object)value);
    }

    public Requester with(String key, Map<String, String> value) {
        return this.with(key, (Object)value);
    }

    public Requester with(@WillClose InputStream body) {
        this.body = body;
        return this;
    }

    public Requester withNullable(String key, Object value) {
        this.args.add(new Entry(key, value));
        return this;
    }

    public Requester with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    public Requester set(String key, Object value) {
        for (int index = 0; index < this.args.size(); ++index) {
            if (!this.args.get((int)index).key.equals(key)) continue;
            this.args.set(index, new Entry(key, value));
            return this;
        }
        return this.with(key, value);
    }

    public Requester method(String method) {
        this.method = method;
        return this;
    }

    public Requester contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    Requester setRawUrlPath(String urlOrPath) {
        Objects.requireNonNull(urlOrPath);
        this.urlPath = urlOrPath;
        return this;
    }

    public Requester withUrlPath(String ... urlPathItems) {
        if (!this.urlPath.startsWith("/")) {
            throw new GHException("Cannot append to url path after setting a raw path");
        }
        if (urlPathItems.length == 1 && !urlPathItems[0].startsWith("/")) {
            return this.setRawUrlPath(urlPathItems[0]);
        }
        String tailUrlPath = String.join((CharSequence)"/", urlPathItems);
        tailUrlPath = this.urlPath.endsWith("/") ? StringUtils.stripStart((String)tailUrlPath, (String)"/") : StringUtils.prependIfMissing((String)tailUrlPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.urlPath = this.urlPath + Requester.urlPathEncode(tailUrlPath);
        return this;
    }

    public Requester inBody() {
        this.forceBody = true;
        return this;
    }

    public void send() throws IOException {
        this._fetch(() -> this.parse(null, null));
    }

    public <T> T fetch(@Nonnull Class<T> type) throws IOException {
        return (T)this._fetch(() -> this.parse(type, null));
    }

    public <T> T[] fetchArray(@Nonnull Class<T[]> type) throws IOException {
        T[] result = null;
        try {
            ArrayList<T[]> pages = new ArrayList<T[]>();
            int totalSize = 0;
            Iterator<T[]> iterator = this.asIterator(type, 0);
            while (iterator.hasNext()) {
                T[] nextResult = iterator.next();
                totalSize += Array.getLength(nextResult);
                pages.add(nextResult);
            }
            result = this.concatenatePages(type, pages, totalSize);
        }
        catch (GHException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        return result;
    }

    public <T> T fetchInto(@Nonnull T existingInstance) throws IOException {
        return (T)this._fetch(() -> this.parse(null, existingInstance));
    }

    public int fetchHttpStatusCode() throws IOException {
        return this._fetch(() -> this.uc.getResponseCode());
    }

    public InputStream fetchStream() throws IOException {
        return this._fetch(() -> this.parse(InputStream.class, null));
    }

    private <T> T _fetch(SupplierThrows<T, IOException> supplier) throws IOException {
        String tailApiUrl = this.buildTailApiUrl(this.urlPath);
        URL url = this.root.getApiURL(tailApiUrl);
        return this._fetch(tailApiUrl, url, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _fetch(String tailApiUrl, URL url, SupplierThrows<T, IOException> supplier) throws IOException {
        while (true) {
            this.uc = this.setupConnection(url);
            try {
                this.retryInvalidCached404Response();
                T t = supplier.get();
                return t;
            }
            catch (IOException e) {
                this.handleApiError(e);
                continue;
            }
            finally {
                this.noteRateLimit(tailApiUrl);
                continue;
            }
            break;
        }
    }

    private <T> T[] concatenatePages(Class<T[]> type, List<T[]> pages, int totalLength) {
        T[] result = type.cast(Array.newInstance(type.getComponentType(), totalLength));
        int position = 0;
        for (T[] page : pages) {
            int pageLength = Array.getLength(page);
            System.arraycopy(page, 0, result, position, pageLength);
            position += pageLength;
        }
        return result;
    }

    private String buildTailApiUrl(String tailApiUrl) {
        if (!this.isMethodWithBody() && !this.args.isEmpty()) {
            try {
                boolean questionMarkFound = tailApiUrl.indexOf(63) != -1;
                StringBuilder argString = new StringBuilder();
                argString.append(questionMarkFound ? (char)'&' : '?');
                ListIterator<Entry> it = this.args.listIterator();
                while (it.hasNext()) {
                    Entry arg = (Entry)it.next();
                    argString.append(URLEncoder.encode(arg.key, StandardCharsets.UTF_8.name()));
                    argString.append('=');
                    argString.append(URLEncoder.encode(arg.value.toString(), StandardCharsets.UTF_8.name()));
                    if (!it.hasNext()) continue;
                    argString.append('&');
                }
                tailApiUrl = tailApiUrl + argString;
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return tailApiUrl;
    }

    private void noteRateLimit(String tailApiUrl) {
        long reset;
        int remaining;
        int limit;
        if (this.uc == null) {
            return;
        }
        if (tailApiUrl.startsWith("/search")) {
            return;
        }
        String limitString = this.uc.getHeaderField("X-RateLimit-Limit");
        if (StringUtils.isBlank((CharSequence)limitString)) {
            return;
        }
        String remainingString = this.uc.getHeaderField("X-RateLimit-Remaining");
        if (StringUtils.isBlank((CharSequence)remainingString)) {
            return;
        }
        String resetString = this.uc.getHeaderField("X-RateLimit-Reset");
        if (StringUtils.isBlank((CharSequence)resetString)) {
            return;
        }
        try {
            limit = Integer.parseInt(limitString);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Limit header value " + limitString, e);
            }
            return;
        }
        try {
            remaining = Integer.parseInt(remainingString);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Remaining header value " + remainingString, e);
            }
            return;
        }
        try {
            reset = Long.parseLong(resetString);
        }
        catch (NumberFormatException e) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Malformed X-RateLimit-Reset header value " + resetString, e);
            }
            return;
        }
        GHRateLimit.Record observed = new GHRateLimit.Record(limit, remaining, reset, this.uc.getHeaderField("Date"));
        this.root.updateCoreRateLimit(observed);
    }

    public String getResponseHeader(String header) {
        return this.uc.getHeaderField(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRequest(HttpURLConnection connection) throws IOException {
        if (this.isMethodWithBody()) {
            connection.setDoOutput(true);
            if (this.body == null) {
                connection.setRequestProperty("Content-type", StringUtils.defaultString((String)this.contentType, (String)"application/json"));
                HashMap<String, Object> json = new HashMap<String, Object>();
                for (Entry e : this.args) {
                    json.put(e.key, e.value);
                }
                GitHub.MAPPER.writeValue(connection.getOutputStream(), json);
            } else {
                connection.setRequestProperty("Content-type", StringUtils.defaultString((String)this.contentType, (String)"application/x-www-form-urlencoded"));
                try {
                    int read;
                    byte[] bytes = new byte[32768];
                    while ((read = this.body.read(bytes)) != -1) {
                        connection.getOutputStream().write(bytes, 0, read);
                    }
                }
                finally {
                    this.body.close();
                }
            }
        }
    }

    private boolean isMethodWithBody() {
        return this.forceBody || !METHODS_WITHOUT_BODY.contains(this.method);
    }

    <T> PagedIterable<T> toIterable(Class<T[]> type, Consumer<T> consumer) {
        return new PagedIterableWithConsumer<T>(type, consumer);
    }

    <T> Iterator<T> asIterator(Class<T> type, int pageSize) {
        if (!"GET".equals(this.method)) {
            throw new IllegalStateException("Request method \"GET\" is required for iterator.");
        }
        if (pageSize > 0) {
            this.args.add(new Entry("per_page", pageSize));
        }
        String tailApiUrl = this.buildTailApiUrl(this.urlPath);
        try {
            return new PagingIterator<T>(type, tailApiUrl, this.root.getApiURL(tailApiUrl));
        }
        catch (IOException e) {
            throw new GHException("Unable to build github Api URL", e);
        }
    }

    private HttpURLConnection setupConnection(URL url) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "GitHub API request [" + (this.root.login == null ? "anonymous" : this.root.login) + "]: " + this.method + " " + url.toString());
        }
        HttpURLConnection connection = this.root.getConnector().connect(url);
        if (this.root.encodedAuthorization != null) {
            connection.setRequestProperty("Authorization", this.root.encodedAuthorization);
        }
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            String v = e.getValue();
            if (v == null) continue;
            connection.setRequestProperty(e.getKey(), v);
        }
        this.setRequestMethod(connection);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        this.buildRequest(connection);
        return connection;
    }

    private void setRequestMethod(HttpURLConnection connection) throws IOException {
        try {
            connection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            try {
                Field $method = HttpURLConnection.class.getDeclaredField("method");
                $method.setAccessible(true);
                $method.set(connection, this.method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
            try {
                Field $delegate = connection.getClass().getDeclaredField("delegate");
                $delegate.setAccessible(true);
                Object delegate = $delegate.get(connection);
                if (delegate instanceof HttpURLConnection) {
                    HttpURLConnection nested = (HttpURLConnection)delegate;
                    this.setRequestMethod(nested);
                }
            }
            catch (NoSuchFieldException $delegate) {
            }
            catch (IllegalAccessException x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        if (!connection.getRequestMethod().equals(this.method)) {
            throw new IllegalStateException("Failed to set the request method to " + this.method);
        }
    }

    @CheckForNull
    private <T> T parse(Class<T> type, T instance) throws IOException {
        return this.parse(type, instance, 2);
    }

    /*
     * Exception decompiling
     */
    private <T> T parse(Class<T> type, T instance, int timeouts) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void retryInvalidCached404Response() throws IOException {
        int responseCode = this.uc.getResponseCode();
        if (responseCode == 404 && Objects.equals(this.uc.getRequestMethod(), "GET") && this.uc.getHeaderField("ETag") != null && !Objects.equals(this.uc.getRequestProperty("Cache-Control"), "no-cache")) {
            this.uc = this.setupConnection(this.uc.getURL());
            this.uc.setRequestProperty("Cache-Control", "no-cache");
            this.uc.getResponseCode();
        }
    }

    private <T> T setResponseHeaders(T readValue) {
        if (readValue instanceof GHObject[]) {
            for (GHObject ghObject : (GHObject[])readValue) {
                this.setResponseHeaders(ghObject);
            }
        } else if (readValue instanceof GHObject) {
            this.setResponseHeaders((GHObject)readValue);
        } else if (readValue instanceof JsonRateLimit) {
            ((JsonRateLimit)readValue).resources.getCore().recalculateResetDate(this.uc.getHeaderField("Date"));
        }
        return readValue;
    }

    private void setResponseHeaders(GHObject readValue) {
        readValue.responseHeaderFields = this.uc.getHeaderFields();
    }

    private InputStream wrapStream(InputStream in) throws IOException {
        String encoding = this.uc.getContentEncoding();
        if (encoding == null || in == null) {
            return in;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleApiError(IOException e) throws IOException {
        int responseCode;
        try {
            responseCode = this.uc.getResponseCode();
        }
        catch (IOException e2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Silently ignore exception retrieving response code for '" + this.uc.getURL() + "' handling exception " + e, e);
            }
            throw e;
        }
        InputStream es = this.wrapStream(this.uc.getErrorStream());
        if (es != null) {
            try {
                String error = IOUtils.toString((InputStream)es, (Charset)StandardCharsets.UTF_8);
                if (e instanceof FileNotFoundException) {
                    e = (IOException)new GHFileNotFoundException(error).withResponseHeaderFields(this.uc).initCause(e);
                } else if (e instanceof HttpException) {
                    HttpException http = (HttpException)e;
                    e = new HttpException(error, http.getResponseCode(), http.getResponseMessage(), http.getUrl(), e);
                } else {
                    e = (IOException)new GHIOException(error).withResponseHeaderFields(this.uc).initCause(e);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)es);
            }
        }
        if (responseCode == 401) {
            if (this.uc.getHeaderField("X-GitHub-OTP") != null) {
                throw (IOException)new GHOTPRequiredException().withResponseHeaderFields(this.uc).initCause(e);
            }
            throw e;
        }
        if ("0".equals(this.uc.getHeaderField("X-RateLimit-Remaining"))) {
            this.root.rateLimitHandler.onError(e, this.uc);
            return;
        }
        if (responseCode == 403 && this.uc.getHeaderField("Retry-After") != null) {
            this.root.abuseLimitHandler.onError(e, this.uc);
            return;
        }
        throw e;
    }

    static String transformEnum(Enum en) {
        return en.toString().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    public static String urlPathEncode(String value) {
        try {
            return new URI(null, null, value, null, null).toString();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @FunctionalInterface
    static interface SupplierThrows<T, E extends Throwable> {
        public T get() throws E;
    }

    class PagingIterator<T>
    implements Iterator<T> {
        private final Class<T> type;
        private final String tailApiUrl;
        private T next;
        private URL url;

        PagingIterator(Class<T> type, String tailApiUrl, URL url) {
            this.type = type;
            this.tailApiUrl = tailApiUrl;
            this.url = url;
        }

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.next != null;
        }

        @Override
        public T next() {
            this.fetch();
            T r = this.next;
            if (r == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetch() {
            if (this.next != null) {
                return;
            }
            if (this.url == null) {
                return;
            }
            try {
                this.next = Requester.this._fetch(this.tailApiUrl, this.url, () -> Requester.this.parse(this.type, null));
                assert (this.next != null);
                this.findNextURL();
            }
            catch (IOException e) {
                throw new GHException("Failed to retrieve " + this.url, e);
            }
        }

        private void findNextURL() throws MalformedURLException {
            this.url = null;
            String link = Requester.this.uc.getHeaderField("Link");
            if (link == null) {
                return;
            }
            for (String token : link.split(", ")) {
                if (!token.endsWith("rel=\"next\"")) continue;
                int idx = token.indexOf(62);
                this.url = new URL(token.substring(1, idx));
                return;
            }
        }
    }

    class PagedIterableWithConsumer<T>
    extends PagedIterable<T> {
        private final Class<T[]> clazz;
        private final Consumer<T> consumer;

        PagedIterableWithConsumer(Class<T[]> clazz, Consumer<T> consumer) {
            this.clazz = clazz;
            this.consumer = consumer;
        }

        @Override
        public PagedIterator<T> _iterator(int pageSize) {
            Iterator<T[]> iterator = Requester.this.asIterator(this.clazz, pageSize);
            return new PagedIterator<T>(iterator){

                @Override
                protected void wrapUp(T[] page) {
                    if (PagedIterableWithConsumer.this.consumer != null) {
                        for (Object item : page) {
                            PagedIterableWithConsumer.this.consumer.accept(item);
                        }
                    }
                }
            };
        }
    }

    private static class Entry {
        final String key;
        final Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

