/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="JSON API")
public class GHRateLimit {
    @Deprecated
    public int remaining;
    @Deprecated
    public int limit;
    @Deprecated
    public Date reset;
    @Nonnull
    private final Record core;
    @Nonnull
    private final Record search;
    @Nonnull
    private final Record graphql;
    @Nonnull
    private final Record integrationManifest;
    private static final Logger LOGGER = Logger.getLogger(Requester.class.getName());

    @Nonnull
    static GHRateLimit Unknown() {
        return new GHRateLimit(new UnknownLimitRecord(), new UnknownLimitRecord(), new UnknownLimitRecord(), new UnknownLimitRecord());
    }

    @Nonnull
    static GHRateLimit fromHeaderRecord(Record header) {
        return new GHRateLimit(header, new UnknownLimitRecord(), new UnknownLimitRecord(), new UnknownLimitRecord());
    }

    @JsonCreator
    GHRateLimit(@Nonnull @JsonProperty(value="core") Record core, @Nonnull @JsonProperty(value="search") Record search, @Nonnull @JsonProperty(value="graphql") Record graphql, @Nonnull @JsonProperty(value="integration_manifest") Record integrationManifest) {
        Objects.requireNonNull(core);
        Objects.requireNonNull(search);
        Objects.requireNonNull(graphql);
        Objects.requireNonNull(integrationManifest);
        this.core = core;
        this.search = search;
        this.graphql = graphql;
        this.integrationManifest = integrationManifest;
        this.remaining = core.getRemaining();
        this.limit = core.getLimit();
        this.reset = new Date(core.getResetEpochSeconds());
    }

    @Nonnull
    public Date getResetDate() {
        return this.getCore().getResetDate();
    }

    public int getRemaining() {
        return this.getCore().getRemaining();
    }

    public int getLimit() {
        return this.getCore().getLimit();
    }

    public long getResetEpochSeconds() {
        return this.getCore().getResetEpochSeconds();
    }

    public boolean isExpired() {
        return this.getCore().isExpired();
    }

    @Nonnull
    public Record getCore() {
        return this.core;
    }

    @Nonnull
    Record getSearch() {
        return this.search;
    }

    @Nonnull
    Record getGraphQL() {
        return this.graphql;
    }

    @Nonnull
    Record getIntegrationManifest() {
        return this.integrationManifest;
    }

    public String toString() {
        return "GHRateLimit {core " + this.getCore().toString() + "search " + this.getSearch().toString() + "graphql " + this.getGraphQL().toString() + "integrationManifest " + this.getIntegrationManifest().toString() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHRateLimit rateLimit = (GHRateLimit)o;
        return this.getCore().equals(rateLimit.getCore()) && this.getSearch().equals(rateLimit.getSearch()) && this.getGraphQL().equals(rateLimit.getGraphQL()) && this.getIntegrationManifest().equals(rateLimit.getIntegrationManifest());
    }

    public int hashCode() {
        return Objects.hash(this.getCore(), this.getSearch(), this.getGraphQL(), this.getIntegrationManifest());
    }

    public static class Record {
        private final int remaining;
        private final int limit;
        private final long resetEpochSeconds;
        private final long createdAtEpochSeconds = System.currentTimeMillis() / 1000L;
        @Nonnull
        private Date resetDate;

        @JsonCreator
        public Record(@JsonProperty(value="limit", required=true) int limit, @JsonProperty(value="remaining", required=true) int remaining, @JsonProperty(value="reset", required=true) long resetEpochSeconds) {
            this(limit, remaining, resetEpochSeconds, null);
        }

        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Deprecated")
        public Record(int limit, int remaining, long resetEpochSeconds, @CheckForNull String updatedAt) {
            this.limit = limit;
            this.remaining = remaining;
            this.resetEpochSeconds = resetEpochSeconds;
            this.resetDate = this.recalculateResetDate(updatedAt);
        }

        Date recalculateResetDate(@CheckForNull String updatedAt) {
            long updatedAtEpochSeconds;
            block3: {
                updatedAtEpochSeconds = this.createdAtEpochSeconds;
                if (!StringUtils.isBlank((CharSequence)updatedAt)) {
                    try {
                        updatedAtEpochSeconds = ZonedDateTime.parse(updatedAt, DateTimeFormatter.RFC_1123_DATE_TIME).toEpochSecond();
                    }
                    catch (DateTimeParseException e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block3;
                        LOGGER.log(Level.FINEST, "Malformed Date header value " + updatedAt, e);
                    }
                }
            }
            long calculatedSecondsUntilReset = this.resetEpochSeconds - updatedAtEpochSeconds;
            this.resetDate = new Date((this.createdAtEpochSeconds + calculatedSecondsUntilReset) * 1000L);
            return this.resetDate;
        }

        public int getRemaining() {
            return this.remaining;
        }

        public int getLimit() {
            return this.limit;
        }

        public long getResetEpochSeconds() {
            return this.resetEpochSeconds;
        }

        public boolean isExpired() {
            return this.getResetDate().getTime() < System.currentTimeMillis();
        }

        @Nonnull
        public Date getResetDate() {
            return new Date(this.resetDate.getTime());
        }

        public String toString() {
            return "{remaining=" + this.getRemaining() + ", limit=" + this.getLimit() + ", resetDate=" + this.getResetDate() + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Record record = (Record)o;
            return this.getRemaining() == record.getRemaining() && this.getLimit() == record.getLimit() && this.getResetEpochSeconds() == record.getResetEpochSeconds() && this.getResetDate().equals(record.getResetDate());
        }

        public int hashCode() {
            return Objects.hash(this.getRemaining(), this.getLimit(), this.getResetEpochSeconds(), this.getResetDate());
        }
    }

    public static class UnknownLimitRecord
    extends Record {
        private static final long unknownLimitResetSeconds = 3600L;
        static final int unknownLimit = 1000000;
        static final int unknownRemaining = 999999;

        private UnknownLimitRecord() {
            super(1000000, 999999, System.currentTimeMillis() / 1000L + 3600L);
        }
    }
}

