/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kie.server.api.model.definition.QueryParam;
import org.kie.server.api.model.definition.TaskField;
import org.kie.server.api.model.definition.TaskQueryFilterSpec;

public class TaskQueryFilterSpecBuilder {
    private List<QueryParam> parameters = new ArrayList<QueryParam>();
    private TaskQueryFilterSpec filterSpec = new TaskQueryFilterSpec();

    public TaskQueryFilterSpec get() {
        if (!this.parameters.isEmpty()) {
            this.filterSpec.setParameters(this.parameters.toArray(new QueryParam[this.parameters.size()]));
        }
        return this.filterSpec;
    }

    public TaskQueryFilterSpecBuilder orderBy(TaskField field, boolean isAscending) {
        this.filterSpec.setOrderBy(field.toString());
        this.filterSpec.setAscending(isAscending);
        return this;
    }

    public TaskQueryFilterSpecBuilder isNull(TaskField field) {
        this.parameters.add(new QueryParam(field.toString(), "IS_NULL", null));
        return this;
    }

    public TaskQueryFilterSpecBuilder isNotNull(TaskField field) {
        this.parameters.add(new QueryParam(field.toString(), "NOT_NULL", null));
        return this;
    }

    public TaskQueryFilterSpecBuilder equalsTo(TaskField field, Comparable<?> ... values) {
        this.parameters.add(new QueryParam(field.toString(), "EQUALS_TO", Arrays.asList(values)));
        return this;
    }

    public TaskQueryFilterSpecBuilder notEqualsTo(TaskField field, Comparable<?> ... values) {
        this.parameters.add(new QueryParam(field.toString(), "NOT_EQUALS_TO", Arrays.asList(values)));
        return this;
    }

    public TaskQueryFilterSpecBuilder likeTo(TaskField field, boolean caseSensitive, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "LIKE_TO", Arrays.asList(value, caseSensitive)));
        return this;
    }

    public TaskQueryFilterSpecBuilder greaterThan(TaskField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "GREATER_THAN", Arrays.asList(value)));
        return this;
    }

    public TaskQueryFilterSpecBuilder greaterOrEqualTo(TaskField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "GREATER_OR_EQUALS_TO", Arrays.asList(value)));
        return this;
    }

    public TaskQueryFilterSpecBuilder lowerThan(TaskField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "LOWER_THAN", Arrays.asList(value)));
        return this;
    }

    public TaskQueryFilterSpecBuilder lowerOrEqualTo(TaskField field, Comparable<?> value) {
        this.parameters.add(new QueryParam(field.toString(), "LOWER_OR_EQUALS_TO", Arrays.asList(value)));
        return this;
    }

    public TaskQueryFilterSpecBuilder between(TaskField field, Comparable<?> start, Comparable<?> end) {
        this.parameters.add(new QueryParam(field.toString(), "BETWEEN", Arrays.asList(start, end)));
        return this;
    }

    public TaskQueryFilterSpecBuilder in(TaskField field, List<?> values) {
        this.parameters.add(new QueryParam(field.toString(), "IN", values));
        return this;
    }

    public TaskQueryFilterSpecBuilder notIn(TaskField field, List<?> values) {
        this.parameters.add(new QueryParam(field.toString(), "NOT_IN", values));
        return this;
    }
}

