/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@XmlRootElement(name="release-id")
@XStreamAlias(value="release-id")
@JsonIgnoreProperties(value={"snapshot"})
public class ReleaseId
implements org.kie.api.builder.ReleaseId {
    @XStreamAlias(value="group-id")
    private String groupId;
    @XStreamAlias(value="artifact-id")
    private String artifactId;
    @XStreamAlias(value="version")
    private String version;

    public ReleaseId() {
    }

    public ReleaseId(org.kie.api.builder.ReleaseId releaseId) {
        this(releaseId.getGroupId(), releaseId.getArtifactId(), releaseId.getVersion());
    }

    public ReleaseId(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @XmlElement(required=true, name="group-id")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @XmlElement(required=true, name="artifact-id")
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @XmlElement(required=true, name="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isSnapshot() {
        return this.version.endsWith("-SNAPSHOT");
    }

    public String toExternalForm() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseId other = (ReleaseId)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

