/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.UUID;
import org.kie.server.api.model.ReleaseId;

public class ConversationId {
    private static final String WRAP = "'";
    private static final String SPLIT_PATTERN = "':'";
    private String kieServerId;
    private String containerId;
    private ReleaseId releaseId;
    private String uniqueString;

    private ConversationId(String kieServerId, String containerId, ReleaseId releaseId) {
        this(kieServerId, containerId, releaseId, UUID.randomUUID().toString());
    }

    private ConversationId(String kieServerId, String containerId, ReleaseId releaseId, String uniqueString) {
        this.kieServerId = kieServerId;
        this.containerId = containerId;
        this.releaseId = releaseId;
        this.uniqueString = uniqueString;
        this.validate();
    }

    public static ConversationId from(String kieServerId, String containerId, ReleaseId releaseId) {
        return new ConversationId(kieServerId, containerId, releaseId);
    }

    public static ConversationId fromString(String conversationIdString) {
        try {
            String conversationId = URLDecoder.decode(conversationIdString, "UTF-8");
            String[] conversationIdElements = conversationId.split(SPLIT_PATTERN);
            if (conversationIdElements.length != 4) {
                throw new IllegalArgumentException("Non-parsable conversationId '" + conversationIdString + WRAP);
            }
            String kieServerId = conversationIdElements[0].replaceAll(WRAP, "");
            String containerId = conversationIdElements[1];
            String[] releaseIdElements = conversationIdElements[2].split(":");
            ReleaseId releaseId = new ReleaseId(releaseIdElements[0], releaseIdElements[1], releaseIdElements[2]);
            String uniqueString = conversationIdElements[3].replaceAll(WRAP, "");
            return new ConversationId(kieServerId, containerId, releaseId, uniqueString);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getKieServerId() {
        return this.kieServerId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public String getUniqueString() {
        return this.uniqueString;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(WRAP).append(this.kieServerId).append(SPLIT_PATTERN).append(this.containerId).append(SPLIT_PATTERN).append(this.releaseId.toExternalForm()).append(SPLIT_PATTERN).append(this.uniqueString).append(WRAP);
        try {
            return URLEncoder.encode(builder.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected void validate() {
        if (this.kieServerId == null || this.kieServerId.isEmpty()) {
            throw new IllegalArgumentException("ConversationId not valid - missing kieServerId");
        }
        if (this.containerId == null || this.containerId.isEmpty()) {
            throw new IllegalArgumentException("ConversationId not valid - missing containerId");
        }
        if (this.releaseId == null) {
            throw new IllegalArgumentException("ConversationId not valid - missing releaseId");
        }
        if (this.uniqueString == null || this.uniqueString.isEmpty()) {
            throw new IllegalArgumentException("ConversationId not valid - missing uniqueString");
        }
    }
}

