/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.device;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.PkceGenerator;
import org.keycloak.testsuite.util.oauth.device.DeviceAuthorizationResponse;

public class DeviceAuthorizationRequest
extends AbstractHttpPostRequest<DeviceAuthorizationRequest, DeviceAuthorizationResponse> {
    DeviceAuthorizationRequest(AbstractOAuthClient<?> client) {
        super(client);
    }

    public DeviceAuthorizationRequest codeChallenge(PkceGenerator pkceGenerator) {
        if (pkceGenerator != null) {
            this.codeChallenge(pkceGenerator.getCodeChallenge(), pkceGenerator.getCodeChallengeMethod());
        }
        return this;
    }

    public DeviceAuthorizationRequest codeChallenge(String codeChallenge, String codeChallengeMethod) {
        this.parameter("code_challenge", codeChallenge);
        this.parameter("code_challenge_method", codeChallengeMethod);
        return this;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getDeviceAuthorization();
    }

    @Override
    protected void initRequest() {
        this.parameter("scope", this.client.config().getScope());
    }

    @Override
    protected DeviceAuthorizationResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new DeviceAuthorizationResponse(response);
    }
}

