/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKParser;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.JwksRequest;

public class KeyManager {
    private final AbstractOAuthClient<?> client;
    private final Map<String, JSONWebKeySet> publicKeys = new HashMap<String, JSONWebKeySet>();

    KeyManager(AbstractOAuthClient<?> client) {
        this.client = client;
    }

    public KeyWrapper getPublicKey(String algorithm, String kid) {
        KeyWrapper key;
        boolean loadedKeysFromServer = false;
        JSONWebKeySet jsonWebKeySet = this.publicKeys.get(this.client.getRealm());
        if (jsonWebKeySet == null) {
            jsonWebKeySet = this.getRealmKeys();
            this.publicKeys.put(this.client.getRealm(), jsonWebKeySet);
            loadedKeysFromServer = true;
        }
        if ((key = this.findKey(jsonWebKeySet, algorithm, kid)) == null && !loadedKeysFromServer) {
            jsonWebKeySet = this.getRealmKeys();
            this.publicKeys.put(this.client.getRealm(), jsonWebKeySet);
            key = this.findKey(jsonWebKeySet, algorithm, kid);
        }
        if (key == null) {
            throw new RuntimeException("Public key for realm:" + this.client.getRealm() + ", algorithm: " + algorithm + " not found");
        }
        return key;
    }

    public JSONWebKeySet getRealmKeys() {
        try {
            return new JwksRequest(this.client).send();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve keys", e);
        }
    }

    private KeyWrapper findKey(JSONWebKeySet jsonWebKeySet, String algorithm, String kid) {
        for (JWK k : jsonWebKeySet.getKeys()) {
            if (!k.getKeyId().equals(kid) || !k.getAlgorithm().equals(algorithm)) continue;
            PublicKey publicKey = JWKParser.create((JWK)k).toPublicKey();
            KeyWrapper key = new KeyWrapper();
            key.setKid(k.getKeyId());
            key.setAlgorithm(k.getAlgorithm());
            if (k.getOtherClaim("crv", String.class) != null) {
                key.setCurve((String)k.getOtherClaim("crv", String.class));
            }
            key.setPublicKey((Key)publicKey);
            key.setUse(KeyUse.SIG);
            return key;
        }
        return null;
    }
}

