/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.protocol.oid4vc.model.AuthorizationDetail;
import org.keycloak.testsuite.util.oauth.AbstractHttpResponse;
import org.keycloak.util.JsonSerialization;

public class AccessTokenResponse
extends AbstractHttpResponse {
    private String idToken;
    private String accessToken;
    private String issuedTokenType;
    private String tokenType;
    private int expiresIn;
    private int refreshExpiresIn;
    private String refreshToken;
    private String scope;
    private String sessionState;
    private List<AuthorizationDetail> authorizationDetails;
    private Map<String, Object> otherClaims;

    public AccessTokenResponse(CloseableHttpResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void parseContent() throws IOException {
        Map responseJson = this.asJson(Map.class);
        this.otherClaims = new HashMap<String, Object>();
        block24: for (Map.Entry entry : responseJson.entrySet()) {
            switch ((String)entry.getKey()) {
                case "id_token": {
                    this.idToken = (String)entry.getValue();
                    continue block24;
                }
                case "access_token": {
                    this.accessToken = (String)entry.getValue();
                    continue block24;
                }
                case "issued_token_type": {
                    this.issuedTokenType = (String)entry.getValue();
                    continue block24;
                }
                case "token_type": {
                    this.tokenType = (String)entry.getValue();
                    continue block24;
                }
                case "expires_in": {
                    this.expiresIn = (Integer)entry.getValue();
                    continue block24;
                }
                case "refresh_expires_in": {
                    this.refreshExpiresIn = (Integer)entry.getValue();
                    continue block24;
                }
                case "session_state": {
                    this.sessionState = (String)entry.getValue();
                    continue block24;
                }
                case "scope": {
                    this.scope = (String)entry.getValue();
                    continue block24;
                }
                case "refresh_token": {
                    this.refreshToken = (String)entry.getValue();
                    continue block24;
                }
                case "authorization_details": {
                    String valJson = JsonSerialization.valueAsString(entry.getValue());
                    AuthorizationDetail[] arr = (AuthorizationDetail[])JsonSerialization.valueFromString((String)valJson, AuthorizationDetail[].class);
                    this.authorizationDetails = Arrays.asList(arr);
                    continue block24;
                }
            }
            this.otherClaims.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public int getRefreshExpiresIn() {
        return this.refreshExpiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getIssuedTokenType() {
        return this.issuedTokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSessionState() {
        return this.sessionState;
    }

    public Map<String, Object> getOtherClaims() {
        return this.otherClaims;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }
}

