/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.util.BasicAuthHelper;

public abstract class AbstractHttpPostRequest<T, R> {
    protected final AbstractOAuthClient<?> client;
    protected String clientId;
    protected String clientSecret;
    protected String clientAssertion;
    protected String clientAssertionType;
    protected HttpPost post;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected List<NameValuePair> parameters = new LinkedList<NameValuePair>();

    public AbstractHttpPostRequest(AbstractOAuthClient<?> client) {
        this.client = client;
    }

    protected abstract String getEndpoint();

    protected abstract void initRequest();

    public R send() {
        this.post = new HttpPost(this.getEndpoint());
        this.post.addHeader("Accept", this.getAccept());
        this.post.addHeader("Origin", this.client.config().getOrigin());
        this.authorization();
        this.initRequest();
        this.headers.forEach((n, v) -> this.post.addHeader(n, v));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(this.parameters, StandardCharsets.UTF_8);
        this.post.setEntity((HttpEntity)formEntity);
        try {
            return this.toResponse(this.client.httpClient().get().execute((HttpUriRequest)this.post));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public T client(String clientId) {
        this.clientId = clientId;
        this.clientSecret = null;
        return this.request();
    }

    public T client(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        return this.request();
    }

    public T clientJwt(String clientAssertion) {
        this.clientAssertion = clientAssertion;
        this.clientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
        return this.request();
    }

    public T clientJwt(String clientAssertion, String clientAssertionType) {
        this.clientAssertion = clientAssertion;
        this.clientAssertionType = clientAssertionType;
        return this.request();
    }

    protected void header(String name, String value) {
        if (value != null) {
            this.headers.put(name, value);
        }
    }

    protected void parameter(String name, String value) {
        if (value != null) {
            this.parameters.add((NameValuePair)new BasicNameValuePair(name, value));
        }
    }

    protected void authorization() {
        String clientSecret;
        String clientId = this.clientId != null ? this.clientId : this.client.config().getClientId();
        String string = clientSecret = this.clientId != null ? this.clientSecret : this.client.config().getClientSecret();
        if (this.clientAssertion != null && this.clientAssertionType != null) {
            this.parameter("client_assertion_type", this.clientAssertionType);
            this.parameter("client_assertion", this.clientAssertion);
        } else if (clientSecret != null) {
            String authorization = BasicAuthHelper.RFC6749.createHeader((String)clientId, (String)clientSecret);
            this.header("Authorization", authorization);
        } else if (clientId != null) {
            this.parameter("client_id", clientId);
        }
    }

    protected void scope() {
        this.scope(true);
    }

    protected void scope(boolean attachOpenidIfNull) {
        this.parameter("scope", this.client.config().getScope(attachOpenidIfNull));
    }

    protected String getAccept() {
        return "application/json";
    }

    protected abstract R toResponse(CloseableHttpResponse var1) throws IOException;

    private T request() {
        return (T)this;
    }
}

