/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.IntrospectionResponse;

public class IntrospectionRequest
extends AbstractHttpPostRequest<IntrospectionRequest, IntrospectionResponse> {
    private final String token;
    private String tokenTypeHint;
    private boolean jwtResponse = false;

    IntrospectionRequest(String token, AbstractOAuthClient<?> client) {
        super(client);
        this.token = token;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getIntrospection();
    }

    public IntrospectionRequest tokenTypeHint(String tokenTypeHint) {
        this.tokenTypeHint = tokenTypeHint;
        return this;
    }

    public IntrospectionRequest jwtResponse() {
        this.jwtResponse = true;
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("token", this.token);
        this.parameter("token_type_hint", this.tokenTypeHint);
    }

    @Override
    protected IntrospectionResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new IntrospectionResponse(response);
    }

    @Override
    protected String getAccept() {
        return this.jwtResponse ? "application/jwt" : super.getAccept();
    }
}

