/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.ParResponse;
import org.keycloak.testsuite.util.oauth.PkceGenerator;

public class ParRequest
extends AbstractHttpPostRequest<ParRequest, ParResponse> {
    public ParRequest(AbstractOAuthClient<?> client) {
        super(client);
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getPushedAuthorizationRequest();
    }

    public ParRequest signedJwt(String signedJwt) {
        this.parameter("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        this.parameter("client_assertion", signedJwt);
        return this;
    }

    public ParRequest nonce(String nonce) {
        this.parameter("nonce", nonce);
        return this;
    }

    public ParRequest state(String state) {
        this.parameter("state", state);
        return this;
    }

    public ParRequest dpopJkt(String dpopJkt) {
        this.parameter("dpop_jkt", dpopJkt);
        return this;
    }

    public ParRequest codeChallenge(PkceGenerator pkceGenerator) {
        if (pkceGenerator != null) {
            this.codeChallenge(pkceGenerator.getCodeChallenge(), pkceGenerator.getCodeChallengeMethod());
        }
        return this;
    }

    public ParRequest codeChallenge(String codeChallenge, String codeChallengeMethod) {
        this.parameter("code_challenge", codeChallenge);
        this.parameter("code_challenge_method", codeChallengeMethod);
        return this;
    }

    public ParRequest dpopProof(String dpopProof) {
        this.header("DPoP", dpopProof);
        return this;
    }

    public ParRequest request(String request) {
        this.parameter("request", request);
        return this;
    }

    public ParRequest requestUri(String requestUri) {
        this.parameter("request_uri", requestUri);
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("response_type", this.client.config().getResponseType());
        this.parameter("response_mode", this.client.config().getResponseMode());
        this.parameter("redirect_uri", this.client.config().getRedirectUri());
        this.parameter("scope", this.client.config().getScope());
    }

    @Override
    protected void authorization() {
        this.parameter("client_id", this.client.config().getClientId());
        this.parameter("client_secret", this.client.config().getClientSecret());
    }

    @Override
    protected ParResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new ParResponse(response);
    }
}

