/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import org.keycloak.representations.ClaimsRepresentation;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AbstractUrlBuilder;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;
import org.keycloak.testsuite.util.oauth.PkceGenerator;

public class LoginUrlBuilder
extends AbstractUrlBuilder {
    public LoginUrlBuilder(AbstractOAuthClient<?> client) {
        super(client);
    }

    @Override
    public String getEndpoint() {
        return this.client.getEndpoints().getAuthorization();
    }

    public LoginUrlBuilder param(String name, String value) {
        this.parameter(name, value);
        return this;
    }

    public LoginUrlBuilder state(String state) {
        this.parameter("state", state);
        return this;
    }

    public LoginUrlBuilder nonce(String nonce) {
        this.parameter("nonce", nonce);
        return this;
    }

    public LoginUrlBuilder prompt(String prompt) {
        this.parameter("prompt", prompt);
        return this;
    }

    public LoginUrlBuilder loginHint(String loginHint) {
        this.parameter("login_hint", loginHint);
        return this;
    }

    public LoginUrlBuilder uiLocales(String uiLocales) {
        this.parameter("ui_locales", uiLocales);
        return this;
    }

    public LoginUrlBuilder maxAge(int maxAge) {
        this.parameter("max_age", Integer.toString(maxAge));
        return this;
    }

    public LoginUrlBuilder kcAction(String kcAction) {
        this.parameter("kc_action", kcAction);
        return this;
    }

    public LoginUrlBuilder codeChallenge(PkceGenerator pkceGenerator) {
        if (pkceGenerator != null) {
            this.codeChallenge(pkceGenerator.getCodeChallenge(), pkceGenerator.getCodeChallengeMethod());
        }
        return this;
    }

    public LoginUrlBuilder codeChallenge(String codeChallenge, String codeChallengeMethod) {
        this.parameter("code_challenge", codeChallenge);
        this.parameter("code_challenge_method", codeChallengeMethod);
        return this;
    }

    public LoginUrlBuilder dpopJkt(String dpopJkt) {
        this.parameter("dpop_jkt", dpopJkt);
        return this;
    }

    public LoginUrlBuilder claims(ClaimsRepresentation claims) {
        this.parameter("claims", claims);
        return this;
    }

    public LoginUrlBuilder request(String request) {
        this.parameter("request", request);
        return this;
    }

    public LoginUrlBuilder requestUri(String requestUri) {
        this.parameter("request_uri", requestUri);
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("response_type", this.client.config().getResponseType());
        this.parameter("response_mode", this.client.config().getResponseMode());
        this.parameter("client_id", this.client.config().getClientId());
        this.parameter("redirect_uri", this.client.config().getRedirectUri());
        this.parameter("scope", this.client.config().getScope());
    }

    public AuthorizationEndpointResponse doLogin(String username, String password) {
        this.open();
        this.client.fillLoginForm(username, password);
        return this.client.parseLoginResponse();
    }
}

