/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.ciba;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpResponse;

public class AuthenticationRequestAcknowledgement
extends AbstractHttpResponse {
    private String authReqId;
    private int expiresIn;
    private int interval;

    public AuthenticationRequestAcknowledgement(CloseableHttpResponse response) throws IOException {
        super(response);
    }

    @Override
    protected void parseContent() throws IOException {
        ObjectNode json = this.asJson();
        this.authReqId = json.get("auth_req_id").asText();
        this.expiresIn = json.get("expires_in").asInt();
        this.interval = json.has("interval") ? json.get("interval").asInt() : -1;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public int getInterval() {
        return this.interval;
    }
}

