/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.utils.URLEncodedUtils;
import org.keycloak.protocol.oidc.utils.OIDCResponseMode;
import org.keycloak.protocol.oidc.utils.OIDCResponseType;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.openqa.selenium.WebDriver;

public class AuthorizationEndpointResponse {
    private boolean isRedirected;
    private Map<String, String> params;

    public AuthorizationEndpointResponse(AbstractOAuthClient<?> client) {
        int parametersIndex;
        WebDriver driver = client.driver;
        String currentUrl = driver.getCurrentUrl();
        boolean fragment = this.isFragment(client);
        int n = parametersIndex = fragment ? currentUrl.indexOf(35) : currentUrl.indexOf(63);
        if (parametersIndex != -1) {
            String urlWithoutParameters = currentUrl.substring(0, parametersIndex);
            String parameters = currentUrl.substring(parametersIndex + 1);
            this.isRedirected = urlWithoutParameters.equals(client.getRedirectUri());
            this.params = new HashMap<String, String>();
            URLEncodedUtils.parse((String)parameters, (Charset)StandardCharsets.UTF_8).stream().filter(p -> p.getValue() != null).forEach(p -> this.params.put(p.getName(), p.getValue()));
        }
    }

    private boolean isFragment(AbstractOAuthClient<?> client) {
        try {
            OIDCResponseType responseType = OIDCResponseType.parse((String)client.config().getResponseType());
            OIDCResponseMode responseMode = OIDCResponseMode.parse((String)client.config().getResponseMode(), (OIDCResponseType)responseType);
            return switch (responseMode) {
                case OIDCResponseMode.FRAGMENT, OIDCResponseMode.FRAGMENT_JWT -> true;
                default -> false;
            };
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isRedirected() {
        return this.isRedirected;
    }

    public String getCode() {
        return this.params.get("code");
    }

    public String getState() {
        return this.params.get("state");
    }

    public String getError() {
        return this.params.get("error");
    }

    public String getErrorDescription() {
        return this.params.get("error_description");
    }

    public String getSessionState() {
        return this.params.get("session_state");
    }

    public String getAccessToken() {
        return this.params.get("access_token");
    }

    public String getIdToken() {
        return this.params.get("id_token");
    }

    public String getTokenType() {
        return this.params.get("token_type");
    }

    public String getExpiresIn() {
        return this.params.get("expires_in");
    }

    public String getResponse() {
        return this.params.get("response");
    }

    public String getIssuer() {
        return this.params.get("iss");
    }

    public String getKcActionStatus() {
        return this.params.get("kc_action_status");
    }
}

