/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.jetty.Jetty94RequestAuthenticator;
import org.keycloak.adapters.jetty.Jetty94SessionManager;
import org.keycloak.adapters.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.jetty.core.AbstractKeycloakJettyAuthenticator;
import org.keycloak.adapters.jetty.core.JettyRequestAuthenticator;
import org.keycloak.adapters.jetty.core.JettySessionTokenStore;
import org.keycloak.adapters.jetty.spi.JettyHttpFacade;
import org.keycloak.adapters.jetty.spi.JettyUserSessionManagement;

public class KeycloakJettyAuthenticator
extends AbstractKeycloakJettyAuthenticator {
    @Override
    protected Request resolveRequest(ServletRequest req) {
        return Request.getBaseRequest((ServletRequest)req);
    }

    @Override
    protected Authentication createAuthentication(UserIdentity userIdentity, final Request request) {
        return new AbstractKeycloakJettyAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public void logout() {
                KeycloakJettyAuthenticator.this.logoutCurrent(request);
            }
        };
    }

    @Override
    public AdapterTokenStore createSessionTokenStore(Request request, KeycloakDeployment resolvedDeployment) {
        return new JettySessionTokenStore(request, resolvedDeployment, new JettyAdapterSessionStore(request));
    }

    @Override
    public JettyUserSessionManagement createSessionManagement(Request request) {
        return new JettyUserSessionManagement(new Jetty94SessionManager(request.getSessionHandler()));
    }

    @Override
    protected JettyRequestAuthenticator createRequestAuthenticator(Request request, JettyHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        return new Jetty94RequestAuthenticator(facade, deployment, tokenStore, -1, request);
    }
}

