/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.proxy.SecurityInfo;
import org.keycloak.proxy.SingleConstraintMatch;

public class SecurityPathMatches {
    private final boolean denyUncoveredHttpMethods;
    private final PathSecurityInformation defaultPathSecurityInformation;
    private final Map<String, PathSecurityInformation> exactPathRoleInformation;
    private final Map<String, PathSecurityInformation> prefixPathRoleInformation;
    private final Map<String, PathSecurityInformation> extensionRoleInformation;

    private SecurityPathMatches(boolean denyUncoveredHttpMethods, PathSecurityInformation defaultPathSecurityInformation, Map<String, PathSecurityInformation> exactPathRoleInformation, Map<String, PathSecurityInformation> prefixPathRoleInformation, Map<String, PathSecurityInformation> extensionRoleInformation) {
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethods;
        this.defaultPathSecurityInformation = defaultPathSecurityInformation;
        this.exactPathRoleInformation = exactPathRoleInformation;
        this.prefixPathRoleInformation = prefixPathRoleInformation;
        this.extensionRoleInformation = extensionRoleInformation;
    }

    public boolean isEmpty() {
        return this.defaultPathSecurityInformation.excludedMethodRoles.isEmpty() && this.defaultPathSecurityInformation.perMethodRequiredRoles.isEmpty() && this.defaultPathSecurityInformation.defaultRequiredRoles.isEmpty() && this.exactPathRoleInformation.isEmpty() && this.prefixPathRoleInformation.isEmpty() && this.extensionRoleInformation.isEmpty();
    }

    public SingleConstraintMatch getSecurityInfo(String path, String method) {
        RuntimeMatch currentMatch = new RuntimeMatch();
        this.handleMatch(method, this.defaultPathSecurityInformation, currentMatch);
        PathSecurityInformation match = this.exactPathRoleInformation.get(path);
        if (match != null) {
            this.handleMatch(method, match, currentMatch);
            return this.mergeConstraints(currentMatch);
        }
        match = this.prefixPathRoleInformation.get(path);
        if (match != null) {
            this.handleMatch(method, match, currentMatch);
            return this.mergeConstraints(currentMatch);
        }
        int qsPos = -1;
        boolean extension = false;
        for (int i = path.length() - 1; i >= 0; --i) {
            String part;
            char c = path.charAt(i);
            if (c == '?') {
                part = path.substring(0, i);
                match = this.exactPathRoleInformation.get(part);
                if (match != null) {
                    this.handleMatch(method, match, currentMatch);
                    return this.mergeConstraints(currentMatch);
                }
                qsPos = i;
                extension = false;
                continue;
            }
            if (c == '/') {
                extension = true;
                part = path.substring(0, i);
                match = this.prefixPathRoleInformation.get(part);
                if (match == null) continue;
                this.handleMatch(method, match, currentMatch);
                return this.mergeConstraints(currentMatch);
            }
            if (c != '.' || extension) continue;
            extension = true;
            String ext = qsPos == -1 ? path.substring(i + 1, path.length()) : path.substring(i + 1, qsPos);
            match = this.extensionRoleInformation.get(ext);
            if (match == null) continue;
            this.handleMatch(method, match, currentMatch);
            return this.mergeConstraints(currentMatch);
        }
        return this.mergeConstraints(currentMatch);
    }

    private SingleConstraintMatch mergeConstraints(RuntimeMatch currentMatch) {
        if (currentMatch.uncovered && this.denyUncoveredHttpMethods) {
            return new SingleConstraintMatch(SecurityInfo.EmptyRoleSemantic.DENY, Collections.<String>emptySet());
        }
        HashSet<String> allowedRoles = new HashSet<String>();
        for (SingleConstraintMatch match : currentMatch.constraints) {
            if (match.getRequiredRoles().isEmpty()) {
                return new SingleConstraintMatch(match.getEmptyRoleSemantic(), Collections.<String>emptySet());
            }
            allowedRoles.addAll(match.getRequiredRoles());
        }
        return new SingleConstraintMatch(SecurityInfo.EmptyRoleSemantic.PERMIT, allowedRoles);
    }

    private void handleMatch(String method, PathSecurityInformation exact, RuntimeMatch currentMatch) {
        List<SecurityInformation> roles = exact.defaultRequiredRoles;
        for (SecurityInformation role : roles) {
            currentMatch.constraints.add(new SingleConstraintMatch(role.emptyRoleSemantic, role.roles));
            if (role.emptyRoleSemantic != SecurityInfo.EmptyRoleSemantic.DENY && role.roles.isEmpty()) continue;
            currentMatch.uncovered = false;
        }
        List<SecurityInformation> methodInfo = exact.perMethodRequiredRoles.get(method);
        if (methodInfo != null) {
            currentMatch.uncovered = false;
            for (SecurityInformation role : methodInfo) {
                currentMatch.constraints.add(new SingleConstraintMatch(role.emptyRoleSemantic, role.roles));
            }
        }
        for (ExcludedMethodRoles excluded : exact.excludedMethodRoles) {
            if (excluded.methods.contains(method)) continue;
            currentMatch.uncovered = false;
            currentMatch.constraints.add(new SingleConstraintMatch(excluded.securityInformation.emptyRoleSemantic, excluded.securityInformation.roles));
        }
    }

    private static final class RuntimeMatch {
        final List<SingleConstraintMatch> constraints = new ArrayList<SingleConstraintMatch>();
        boolean uncovered = true;

        private RuntimeMatch() {
        }
    }

    private static final class SecurityInformation {
        final Set<String> roles;
        final SecurityInfo.EmptyRoleSemantic emptyRoleSemantic;

        private SecurityInformation(Set<String> roles, SecurityInfo.EmptyRoleSemantic emptyRoleSemantic) {
            this.emptyRoleSemantic = emptyRoleSemantic;
            this.roles = new HashSet<String>(roles);
        }
    }

    private static final class ExcludedMethodRoles {
        final Set<String> methods;
        final SecurityInformation securityInformation;

        public ExcludedMethodRoles(Set<String> methods, SecurityInformation securityInformation) {
            this.methods = methods;
            this.securityInformation = securityInformation;
        }
    }

    private static class PathSecurityInformation {
        final List<SecurityInformation> defaultRequiredRoles = new ArrayList<SecurityInformation>();
        final Map<String, List<SecurityInformation>> perMethodRequiredRoles = new HashMap<String, List<SecurityInformation>>();
        final List<ExcludedMethodRoles> excludedMethodRoles = new ArrayList<ExcludedMethodRoles>();

        private PathSecurityInformation() {
        }
    }

    public static class Builder {
        private final PathSecurityInformation defaultPathSecurityInformation = new PathSecurityInformation();
        private final Map<String, PathSecurityInformation> exactPathRoleInformation = new HashMap<String, PathSecurityInformation>();
        private final Map<String, PathSecurityInformation> prefixPathRoleInformation = new HashMap<String, PathSecurityInformation>();
        private final Map<String, PathSecurityInformation> extensionRoleInformation = new HashMap<String, PathSecurityInformation>();

        public void addSecurityConstraint(Set<String> roles, SecurityInfo.EmptyRoleSemantic emptyRoleSemantic, String pattern, Set<String> httpMethods, Set<String> excludedMethods) {
            SecurityInformation securityInformation = new SecurityInformation(roles, emptyRoleSemantic);
            if (pattern.endsWith("/*") || pattern.endsWith("/")) {
                String part = pattern.substring(0, pattern.lastIndexOf(47));
                PathSecurityInformation info = this.prefixPathRoleInformation.get(part);
                if (info == null) {
                    info = new PathSecurityInformation();
                    this.prefixPathRoleInformation.put(part, info);
                }
                this.setupPathSecurityInformation(info, securityInformation, httpMethods, excludedMethods);
            } else if (pattern.startsWith("*.")) {
                String part = pattern.substring(2, pattern.length());
                PathSecurityInformation info = this.extensionRoleInformation.get(part);
                if (info == null) {
                    info = new PathSecurityInformation();
                    this.extensionRoleInformation.put(part, info);
                }
                this.setupPathSecurityInformation(info, securityInformation, httpMethods, excludedMethods);
            } else {
                PathSecurityInformation info = this.exactPathRoleInformation.get(pattern);
                if (info == null) {
                    info = new PathSecurityInformation();
                    this.exactPathRoleInformation.put(pattern, info);
                }
                this.setupPathSecurityInformation(info, securityInformation, httpMethods, excludedMethods);
            }
        }

        private Set<String> expandRolesAllowed(Set<String> rolesAllowed) {
            HashSet<String> roles = new HashSet<String>(rolesAllowed);
            return roles;
        }

        private void setupPathSecurityInformation(PathSecurityInformation info, SecurityInformation securityConstraint, Set<String> httpMethods, Set<String> excludedMethods) {
            if (httpMethods.isEmpty() && excludedMethods.isEmpty()) {
                info.defaultRequiredRoles.add(securityConstraint);
            } else if (!httpMethods.isEmpty()) {
                for (String method : httpMethods) {
                    List<SecurityInformation> securityInformations = info.perMethodRequiredRoles.get(method);
                    if (securityInformations == null) {
                        securityInformations = new ArrayList<SecurityInformation>();
                        info.perMethodRequiredRoles.put(method, securityInformations);
                    }
                    securityInformations.add(securityConstraint);
                }
            } else if (!excludedMethods.isEmpty()) {
                info.excludedMethodRoles.add(new ExcludedMethodRoles(excludedMethods, securityConstraint));
            }
        }

        public SecurityPathMatches build() {
            return new SecurityPathMatches(false, this.defaultPathSecurityInformation, this.exactPathRoleInformation, this.prefixPathRoleInformation, this.extensionRoleInformation);
        }
    }
}

