/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;

public interface ClientSessionModel {
    public String getId();

    public RealmModel getRealm();

    public ClientModel getClient();

    public UserSessionModel getUserSession();

    public void setUserSession(UserSessionModel var1);

    public String getRedirectUri();

    public void setRedirectUri(String var1);

    public int getTimestamp();

    public void setTimestamp(int var1);

    public String getAction();

    public void setAction(String var1);

    public Set<String> getRoles();

    public void setRoles(Set<String> var1);

    public Set<String> getProtocolMappers();

    public void setProtocolMappers(Set<String> var1);

    public Map<String, ExecutionStatus> getExecutionStatus();

    public void setExecutionStatus(String var1, ExecutionStatus var2);

    public void clearExecutionStatus();

    public UserModel getAuthenticatedUser();

    public void setAuthenticatedUser(UserModel var1);

    public String getAuthMethod();

    public void setAuthMethod(String var1);

    public String getNote(String var1);

    public void setNote(String var1, String var2);

    public void removeNote(String var1);

    public Map<String, String> getNotes();

    public Set<String> getRequiredActions();

    public void addRequiredAction(String var1);

    public void removeRequiredAction(String var1);

    public void addRequiredAction(UserModel.RequiredAction var1);

    public void removeRequiredAction(UserModel.RequiredAction var1);

    public void setUserSessionNote(String var1, String var2);

    public Map<String, String> getUserSessionNotes();

    public void clearUserSessionNotes();

    public static enum ExecutionStatus {
        FAILED,
        SUCCESS,
        SETUP_REQUIRED,
        ATTEMPTED,
        SKIPPED,
        CHALLENGED;

    }

    public static enum Action {
        OAUTH_GRANT,
        CODE_TO_TOKEN,
        VERIFY_EMAIL,
        UPDATE_PROFILE,
        CONFIGURE_TOTP,
        UPDATE_PASSWORD,
        RECOVER_PASSWORD,
        AUTHENTICATE,
        SOCIAL_CALLBACK,
        LOGGED_OUT,
        RESET_CREDENTIALS,
        EXECUTE_ACTIONS;

    }
}

