/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClaimMask;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ApplicationRepresentation;
import org.keycloak.representations.idm.ClaimRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.SocialLinkRepresentation;
import org.keycloak.representations.idm.UserFederationProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;

public class ModelToRepresentation {
    public static UserRepresentation toRepresentation(UserModel user) {
        UserRepresentation rep = new UserRepresentation();
        rep.setId(user.getId());
        rep.setUsername(user.getUsername());
        rep.setLastName(user.getLastName());
        rep.setFirstName(user.getFirstName());
        rep.setEmail(user.getEmail());
        rep.setEnabled(user.isEnabled());
        rep.setEmailVerified(user.isEmailVerified());
        rep.setTotp(user.isTotp());
        rep.setFederationLink(user.getFederationLink());
        ArrayList<String> reqActions = new ArrayList<String>();
        for (UserModel.RequiredAction ra : user.getRequiredActions()) {
            reqActions.add(ra.name());
        }
        rep.setRequiredActions(reqActions);
        if (user.getAttributes() != null && !user.getAttributes().isEmpty()) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.putAll(user.getAttributes());
            rep.setAttributes(attrs);
        }
        return rep;
    }

    public static RoleRepresentation toRepresentation(RoleModel role) {
        RoleRepresentation rep = new RoleRepresentation();
        rep.setId(role.getId());
        rep.setName(role.getName());
        rep.setDescription(role.getDescription());
        rep.setComposite(role.isComposite());
        return rep;
    }

    public static RealmRepresentation toRepresentation(RealmModel realm, boolean internal) {
        List<UserFederationProviderModel> fedProviderModels;
        List<RequiredCredentialModel> requiredCredentialModels;
        List<String> defaultRoles;
        RealmRepresentation rep = new RealmRepresentation();
        rep.setId(realm.getId());
        rep.setRealm(realm.getName());
        rep.setEnabled(Boolean.valueOf(realm.isEnabled()));
        rep.setSocial(Boolean.valueOf(realm.isSocial()));
        rep.setNotBefore(Integer.valueOf(realm.getNotBefore()));
        rep.setUpdateProfileOnInitialSocialLogin(Boolean.valueOf(realm.isUpdateProfileOnInitialSocialLogin()));
        rep.setSslRequired(realm.getSslRequired().name().toLowerCase());
        rep.setPublicKey(realm.getPublicKeyPem());
        if (internal) {
            rep.setPrivateKey(realm.getPrivateKeyPem());
            String privateKeyPem = realm.getPrivateKeyPem();
            if (realm.getCertificatePem() == null && privateKeyPem != null) {
                KeycloakModelUtils.generateRealmCertificate(realm);
            }
            rep.setCodeSecret(realm.getCodeSecret());
        }
        rep.setCertificate(realm.getCertificatePem());
        rep.setPasswordCredentialGrantAllowed(Boolean.valueOf(realm.isPasswordCredentialGrantAllowed()));
        rep.setRegistrationAllowed(Boolean.valueOf(realm.isRegistrationAllowed()));
        rep.setRememberMe(Boolean.valueOf(realm.isRememberMe()));
        rep.setBruteForceProtected(Boolean.valueOf(realm.isBruteForceProtected()));
        rep.setMaxFailureWaitSeconds(Integer.valueOf(realm.getMaxFailureWaitSeconds()));
        rep.setMinimumQuickLoginWaitSeconds(Integer.valueOf(realm.getMinimumQuickLoginWaitSeconds()));
        rep.setWaitIncrementSeconds(Integer.valueOf(realm.getWaitIncrementSeconds()));
        rep.setQuickLoginCheckMilliSeconds(Long.valueOf(realm.getQuickLoginCheckMilliSeconds()));
        rep.setMaxDeltaTimeSeconds(Integer.valueOf(realm.getMaxDeltaTimeSeconds()));
        rep.setFailureFactor(Integer.valueOf(realm.getFailureFactor()));
        rep.setVerifyEmail(Boolean.valueOf(realm.isVerifyEmail()));
        rep.setResetPasswordAllowed(Boolean.valueOf(realm.isResetPasswordAllowed()));
        rep.setAccessTokenLifespan(Integer.valueOf(realm.getAccessTokenLifespan()));
        rep.setSsoSessionIdleTimeout(Integer.valueOf(realm.getSsoSessionIdleTimeout()));
        rep.setSsoSessionMaxLifespan(Integer.valueOf(realm.getSsoSessionMaxLifespan()));
        rep.setAccessCodeLifespan(Integer.valueOf(realm.getAccessCodeLifespan()));
        rep.setAccessCodeLifespanUserAction(Integer.valueOf(realm.getAccessCodeLifespanUserAction()));
        rep.setSmtpServer(realm.getSmtpConfig());
        rep.setSocialProviders(realm.getSocialConfig());
        rep.setBrowserSecurityHeaders(realm.getBrowserSecurityHeaders());
        rep.setAccountTheme(realm.getAccountTheme());
        rep.setLoginTheme(realm.getLoginTheme());
        rep.setAdminTheme(realm.getAdminTheme());
        rep.setEmailTheme(realm.getEmailTheme());
        if (realm.getPasswordPolicy() != null) {
            rep.setPasswordPolicy(realm.getPasswordPolicy().toString());
        }
        if (!(defaultRoles = realm.getDefaultRoles()).isEmpty()) {
            ArrayList<String> roleStrings = new ArrayList<String>();
            roleStrings.addAll(defaultRoles);
            rep.setDefaultRoles(roleStrings);
        }
        if ((requiredCredentialModels = realm.getRequiredCredentials()).size() > 0) {
            rep.setRequiredCredentials(new HashSet());
            for (RequiredCredentialModel cred : requiredCredentialModels) {
                rep.getRequiredCredentials().add(cred.getType());
            }
        }
        if ((fedProviderModels = realm.getUserFederationProviders()).size() > 0) {
            ArrayList<UserFederationProviderRepresentation> fedProviderReps = new ArrayList<UserFederationProviderRepresentation>();
            for (UserFederationProviderModel model : fedProviderModels) {
                UserFederationProviderRepresentation fedProvRep = ModelToRepresentation.toRepresentation(model);
                fedProviderReps.add(fedProvRep);
            }
            rep.setUserFederationProviders(fedProviderReps);
        }
        return rep;
    }

    public static RealmEventsConfigRepresentation toEventsConfigReprensetation(RealmModel realm) {
        RealmEventsConfigRepresentation rep = new RealmEventsConfigRepresentation();
        rep.setEventsEnabled(realm.isEventsEnabled());
        if (realm.getEventsExpiration() != 0L) {
            rep.setEventsExpiration(Long.valueOf(realm.getEventsExpiration()));
        }
        if (realm.getEventsListeners() != null) {
            rep.setEventsListeners(new LinkedList<String>(realm.getEventsListeners()));
        }
        return rep;
    }

    public static CredentialRepresentation toRepresentation(UserCredentialModel cred) {
        CredentialRepresentation rep = new CredentialRepresentation();
        rep.setType("secret");
        rep.setValue(cred.getValue());
        return rep;
    }

    public static ClaimRepresentation toRepresentation(ClientModel model) {
        ClaimRepresentation rep = new ClaimRepresentation();
        rep.setAddress(ClaimMask.hasAddress(model.getAllowedClaimsMask()));
        rep.setEmail(ClaimMask.hasEmail(model.getAllowedClaimsMask()));
        rep.setGender(ClaimMask.hasGender(model.getAllowedClaimsMask()));
        rep.setLocale(ClaimMask.hasLocale(model.getAllowedClaimsMask()));
        rep.setName(ClaimMask.hasName(model.getAllowedClaimsMask()));
        rep.setPhone(ClaimMask.hasPhone(model.getAllowedClaimsMask()));
        rep.setPicture(ClaimMask.hasPicture(model.getAllowedClaimsMask()));
        rep.setProfile(ClaimMask.hasProfile(model.getAllowedClaimsMask()));
        rep.setWebsite(ClaimMask.hasWebsite(model.getAllowedClaimsMask()));
        rep.setUsername(ClaimMask.hasUsername(model.getAllowedClaimsMask()));
        return rep;
    }

    public static SocialLinkRepresentation toRepresentation(SocialLinkModel socialLink) {
        SocialLinkRepresentation rep = new SocialLinkRepresentation();
        rep.setSocialUsername(socialLink.getSocialUsername());
        rep.setSocialProvider(socialLink.getSocialProvider());
        rep.setSocialUserId(socialLink.getSocialUserId());
        return rep;
    }

    public static UserSessionRepresentation toRepresentation(UserSessionModel session) {
        UserSessionRepresentation rep = new UserSessionRepresentation();
        rep.setId(session.getId());
        rep.setStart((long)session.getStarted() * 1000L);
        rep.setLastAccess((long)session.getLastSessionRefresh() * 1000L);
        rep.setUser(session.getUser().getUsername());
        rep.setIpAddress(session.getIpAddress());
        for (ClientSessionModel clientSession : session.getClientSessions()) {
            ClientModel client = clientSession.getClient();
            if (client instanceof ApplicationModel) {
                rep.getApplications().put(client.getId(), client.getClientId());
                continue;
            }
            if (!(client instanceof OAuthClientModel)) continue;
            rep.getClients().put(client.getId(), client.getClientId());
        }
        return rep;
    }

    public static ApplicationRepresentation toRepresentation(ApplicationModel applicationModel) {
        Set<String> webOrigins;
        ApplicationRepresentation rep = new ApplicationRepresentation();
        rep.setId(applicationModel.getId());
        rep.setName(applicationModel.getName());
        rep.setEnabled(Boolean.valueOf(applicationModel.isEnabled()));
        rep.setAdminUrl(applicationModel.getManagementUrl());
        rep.setPublicClient(Boolean.valueOf(applicationModel.isPublicClient()));
        rep.setProtocol(applicationModel.getProtocol());
        rep.setAttributes(applicationModel.getAttributes());
        rep.setFullScopeAllowed(Boolean.valueOf(applicationModel.isFullScopeAllowed()));
        rep.setBearerOnly(Boolean.valueOf(applicationModel.isBearerOnly()));
        rep.setSurrogateAuthRequired(Boolean.valueOf(applicationModel.isSurrogateAuthRequired()));
        rep.setBaseUrl(applicationModel.getBaseUrl());
        rep.setNotBefore(Integer.valueOf(applicationModel.getNotBefore()));
        rep.setNodeReRegistrationTimeout(Integer.valueOf(applicationModel.getNodeReRegistrationTimeout()));
        Set<String> redirectUris = applicationModel.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList<String>(redirectUris));
        }
        if ((webOrigins = applicationModel.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList<String>(webOrigins));
        }
        if (!applicationModel.getDefaultRoles().isEmpty()) {
            rep.setDefaultRoles(applicationModel.getDefaultRoles().toArray(new String[0]));
        }
        if (!applicationModel.getRegisteredNodes().isEmpty()) {
            rep.setRegisteredNodes(new HashMap<String, Integer>(applicationModel.getRegisteredNodes()));
        }
        return rep;
    }

    public static OAuthClientRepresentation toRepresentation(OAuthClientModel model) {
        Set<String> webOrigins;
        OAuthClientRepresentation rep = new OAuthClientRepresentation();
        rep.setId(model.getId());
        rep.setName(model.getClientId());
        rep.setEnabled(Boolean.valueOf(model.isEnabled()));
        rep.setPublicClient(Boolean.valueOf(model.isPublicClient()));
        rep.setProtocol(model.getProtocol());
        rep.setAttributes(model.getAttributes());
        rep.setFullScopeAllowed(Boolean.valueOf(model.isFullScopeAllowed()));
        rep.setDirectGrantsOnly(Boolean.valueOf(model.isDirectGrantsOnly()));
        Set<String> redirectUris = model.getRedirectUris();
        if (redirectUris != null) {
            rep.setRedirectUris(new LinkedList<String>(redirectUris));
        }
        if ((webOrigins = model.getWebOrigins()) != null) {
            rep.setWebOrigins(new LinkedList<String>(webOrigins));
        }
        rep.setNotBefore(Integer.valueOf(model.getNotBefore()));
        return rep;
    }

    public static UserFederationProviderRepresentation toRepresentation(UserFederationProviderModel model) {
        UserFederationProviderRepresentation rep = new UserFederationProviderRepresentation();
        rep.setId(model.getId());
        rep.setConfig(model.getConfig());
        rep.setProviderName(model.getProviderName());
        rep.setPriority(model.getPriority());
        rep.setDisplayName(model.getDisplayName());
        rep.setFullSyncPeriod(model.getFullSyncPeriod());
        rep.setChangedSyncPeriod(model.getChangedSyncPeriod());
        rep.setLastSync(model.getLastSync());
        return rep;
    }
}

