/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;

public class CachedUser
implements Serializable {
    private String id;
    private String realm;
    private String username;
    private String firstName;
    private String lastName;
    private String email;
    private boolean emailVerified;
    private List<UserCredentialValueModel> credentials = new LinkedList<UserCredentialValueModel>();
    private boolean enabled;
    private boolean totp;
    private String federationLink;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Set<String> requiredActions = new HashSet<String>();
    private Set<String> roleMappings = new HashSet<String>();

    public CachedUser(RealmModel realm, UserModel user) {
        this.id = user.getId();
        this.realm = realm.getId();
        this.username = user.getUsername();
        this.firstName = user.getFirstName();
        this.lastName = user.getLastName();
        this.attributes.putAll(user.getAttributes());
        this.email = user.getEmail();
        this.emailVerified = user.isEmailVerified();
        this.credentials.addAll(user.getCredentialsDirectly());
        this.enabled = user.isEnabled();
        this.totp = user.isTotp();
        this.federationLink = user.getFederationLink();
        this.requiredActions.addAll(user.getRequiredActions());
        for (RoleModel role : user.getRoleMappings()) {
            this.roleMappings.add(role.getId());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public List<UserCredentialValueModel> getCredentials() {
        return this.credentials;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTotp() {
        return this.totp;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<String> getRequiredActions() {
        return this.requiredActions;
    }

    public Set<String> getRoleMappings() {
        return this.roleMappings;
    }

    public String getFederationLink() {
        return this.federationLink;
    }
}

