/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.entities.CachedUser;

public class MemoryUserCache
implements UserCache {
    protected int maxUserCacheSize = 10000;
    protected volatile boolean enabled = true;
    protected ConcurrentHashMap<String, RealmUsers> realmUsers = new ConcurrentHashMap();

    public int getMaxUserCacheSize() {
        return this.maxUserCacheSize;
    }

    public void setMaxUserCacheSize(int maxUserCacheSize) {
        this.maxUserCacheSize = maxUserCacheSize;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.clear();
        this.enabled = enabled;
        this.clear();
    }

    @Override
    public CachedUser getCachedUser(String realmId, String id) {
        if (realmId == null || id == null) {
            return null;
        }
        RealmUsers users = this.realmUsers.get(realmId);
        if (users == null) {
            return null;
        }
        return users.usersById.get(id);
    }

    @Override
    public void invalidateCachedUser(String realmId, CachedUser user) {
        RealmUsers users = this.realmUsers.get(realmId);
        if (users == null) {
            return;
        }
        users.usersById.remove(user.getId());
    }

    @Override
    public void invalidateCachedUserById(String realmId, String id) {
        RealmUsers users = this.realmUsers.get(realmId);
        if (users == null) {
            return;
        }
        users.usersById.remove(id);
    }

    @Override
    public void addCachedUser(String realmId, CachedUser user) {
        RealmUsers users = this.realmUsers.get(realmId);
        if (users == null) {
            users = new RealmUsers();
            this.realmUsers.put(realmId, users);
        }
        users.usersById.put(user.getId(), user);
    }

    @Override
    public CachedUser getCachedUserByUsername(String realmId, String name) {
        if (realmId == null || name == null) {
            return null;
        }
        RealmUsers users = this.realmUsers.get(realmId);
        if (users == null) {
            return null;
        }
        CachedUser user = users.usersByUsername.get(name);
        if (user == null) {
            return null;
        }
        users.usersById.get(user.getId());
        return user;
    }

    @Override
    public CachedUser getCachedUserByEmail(String realmId, String email) {
        if (realmId == null || email == null) {
            return null;
        }
        RealmUsers users = this.realmUsers.get(realmId);
        if (users == null) {
            return null;
        }
        CachedUser user = users.usersByEmail.get(email);
        if (user == null) {
            return null;
        }
        users.usersById.get(user.getId());
        return user;
    }

    @Override
    public void invalidateRealmUsers(String realmId) {
        this.realmUsers.remove(realmId);
    }

    @Override
    public void clear() {
        this.realmUsers.clear();
    }

    protected class RealmUsers {
        protected Map<String, CachedUser> usersById = Collections.synchronizedMap(new LRUCache());
        protected Map<String, CachedUser> usersByUsername = new ConcurrentHashMap<String, CachedUser>();
        protected Map<String, CachedUser> usersByEmail = new ConcurrentHashMap<String, CachedUser>();

        protected RealmUsers() {
        }

        protected class LRUCache
        extends LinkedHashMap<String, CachedUser> {
            public LRUCache() {
                super(1000, 1.1f, true);
            }

            @Override
            public CachedUser put(String key, CachedUser value) {
                if (value.getUsername() != null) {
                    RealmUsers.this.usersByUsername.put(value.getUsername(), value);
                }
                if (value.getEmail() != null) {
                    RealmUsers.this.usersByEmail.put(value.getEmail(), value);
                }
                return super.put(key, value);
            }

            @Override
            public CachedUser remove(Object key) {
                CachedUser user = (CachedUser)super.remove(key);
                if (user == null) {
                    return null;
                }
                this.removeUser(user);
                return user;
            }

            @Override
            public void clear() {
                super.clear();
                RealmUsers.this.usersByUsername.clear();
                RealmUsers.this.usersByEmail.clear();
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, CachedUser> eldest) {
                boolean evict;
                boolean bl = evict = this.size() > MemoryUserCache.this.maxUserCacheSize;
                if (evict) {
                    this.removeUser(eldest.getValue());
                }
                return evict;
            }

            private void removeUser(CachedUser value) {
                if (value.getUsername() != null) {
                    RealmUsers.this.usersByUsername.remove(value.getUsername());
                }
                if (value.getEmail() != null) {
                    RealmUsers.this.usersByEmail.remove(value.getEmail());
                }
            }
        }
    }
}

