/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.keycloak.common.util.BouncyIntegration;

public final class OCSPUtils {
    private static final Logger logger;
    private static int OCSP_CONNECT_TIMEOUT;
    private static final int TIME_SKEW = 900000;

    public static OCSPRevocationStatus check(X509Certificate cert, X509Certificate issuerCertificate, URI responderURI, X509Certificate responderCert, Date date) throws CertPathValidatorException {
        if (cert == null) {
            throw new IllegalArgumentException("cert cannot be null");
        }
        if (issuerCertificate == null) {
            throw new IllegalArgumentException("issuerCertificate cannot be null");
        }
        if (responderURI == null) {
            throw new IllegalArgumentException("responderURI cannot be null");
        }
        return OCSPUtils.check(cert, issuerCertificate, Collections.singletonList(responderURI), responderCert, date);
    }

    public static OCSPRevocationStatus check(X509Certificate cert, X509Certificate issuerCertificate, Date date, X509Certificate responderCert) throws CertPathValidatorException {
        List<String> responderURIs = null;
        try {
            responderURIs = OCSPUtils.getResponderURIs(cert);
        }
        catch (CertificateEncodingException e) {
            logger.log(Level.FINE, "CertificateEncodingException: {0}", e.getMessage());
            throw new CertPathValidatorException(e.getMessage(), e);
        }
        if (responderURIs.size() == 0) {
            logger.log(Level.INFO, "No OCSP responders in the specified certificate");
            throw new CertPathValidatorException("No OCSP Responder URI in certificate");
        }
        LinkedList<URI> uris = new LinkedList<URI>();
        for (String value : responderURIs) {
            try {
                URI responderURI = URI.create(value);
                uris.add(responderURI);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.FINE, "Malformed responder URI {0}", value);
            }
        }
        return OCSPUtils.check(cert, issuerCertificate, Collections.unmodifiableList(uris), responderCert, date);
    }

    public static OCSPRevocationStatus check(X509Certificate cert, X509Certificate issuerCertificate) throws CertPathValidatorException {
        return OCSPUtils.check(cert, issuerCertificate, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OCSPResp getResponse(OCSPReq ocspReq, URI responderUri) throws IOException {
        FilterOutputStream dataOut = null;
        InputStream in = null;
        try {
            byte[] array = ocspReq.getEncoded();
            URL urlt = responderUri.toURL();
            HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
            con.setRequestMethod("POST");
            con.setConnectTimeout(OCSP_CONNECT_TIMEOUT);
            con.setReadTimeout(OCSP_CONNECT_TIMEOUT);
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(array.length));
            con.setDoOutput(true);
            con.setDoInput(true);
            OutputStream out = con.getOutputStream();
            dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(array);
            ((DataOutputStream)dataOut).flush();
            if (con.getResponseCode() / 100 != 2) {
                String errorMessage = String.format("Connection error, unable to obtain certificate revocation status using OCSP responder \"%s\", code \"%d\"", responderUri.toString(), con.getResponseCode());
                throw new IOException(errorMessage);
            }
            in = con.getInputStream();
            int contentLen = con.getContentLength();
            if (contentLen == -1) {
                contentLen = Integer.MAX_VALUE;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[2048];
            while ((bytesRead = in.read(buffer, 0, buffer.length)) >= 0) {
                baos.write(buffer, 0, bytesRead);
            }
            baos.flush();
            byte[] data = baos.toByteArray();
            OCSPResp oCSPResp = new OCSPResp(data);
            return oCSPResp;
        }
        finally {
            if (dataOut != null) {
                dataOut.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    private static OCSPRevocationStatus check(X509Certificate cert, X509Certificate issuerCertificate, List<URI> responderURIs, X509Certificate responderCert, Date date) throws CertPathValidatorException {
        if (responderURIs == null || responderURIs.size() == 0) {
            throw new IllegalArgumentException("Need at least one responder");
        }
        try {
            DigestCalculator digCalc = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
            JcaCertificateID certificateID = new JcaCertificateID(digCalc, issuerCertificate, cert.getSerialNumber());
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            BigInteger nounce = BigInteger.valueOf(Math.abs(random.nextInt()));
            DEROctetString derString = new DEROctetString(nounce.toByteArray());
            Extension nounceExtension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)derString);
            Extensions extensions = new Extensions(nounceExtension);
            OCSPReq ocspReq = new OCSPReqBuilder().addRequest((CertificateID)certificateID, extensions).build();
            URI responderURI = responderURIs.get(0);
            logger.log(Level.INFO, "OCSP Responder {0}", responderURI);
            try {
                OCSPResp resp = OCSPUtils.getResponse(ocspReq, responderURI);
                logger.log(Level.FINE, "Received a response from OCSP responder {0}, the response status is {1}", new Object[]{responderURI, resp.getStatus()});
                switch (resp.getStatus()) {
                    case 0: {
                        if (resp.getResponseObject() instanceof BasicOCSPResp) {
                            return OCSPUtils.processBasicOCSPResponse(issuerCertificate, responderCert, date, certificateID, nounce, (BasicOCSPResp)resp.getResponseObject());
                        }
                        throw new CertPathValidatorException("OCSP responder returned an invalid or unknown OCSP response.");
                    }
                    case 2: 
                    case 3: {
                        throw new CertPathValidatorException("Internal error/try later. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                    }
                    case 5: {
                        throw new CertPathValidatorException("Invalid or missing signature. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.INVALID_SIGNATURE);
                    }
                    case 6: {
                        throw new CertPathValidatorException("Unauthorized request. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.UNSPECIFIED);
                    }
                }
                throw new CertPathValidatorException("OCSP request is malformed. OCSP response error: " + resp.getStatus(), null, null, -1, CertPathValidatorException.BasicReason.UNSPECIFIED);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "OCSP Responder \"{0}\" failed to return a valid OCSP response\n{1}", new Object[]{responderURI, e.getMessage()});
                throw new CertPathValidatorException("OCSP check failed", e);
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateEncodingException | CertificateExpiredException | CertificateNotYetValidException | OCSPException | OperatorCreationException e) {
            logger.log(Level.FINE, e.getMessage());
            throw new CertPathValidatorException(e.getMessage(), e);
        }
    }

    private static OCSPRevocationStatus processBasicOCSPResponse(X509Certificate issuerCertificate, X509Certificate responderCertificate, Date date, JcaCertificateID certificateID, BigInteger nounce, BasicOCSPResp basicOcspResponse) throws OCSPException, NoSuchProviderException, NoSuchAlgorithmException, CertificateNotYetValidException, CertificateExpiredException, CertPathValidatorException {
        SingleResp expectedResponse = null;
        for (SingleResp singleResponse : basicOcspResponse.getResponses()) {
            if (!OCSPUtils.compareCertIDs(certificateID, singleResponse.getCertID())) continue;
            expectedResponse = singleResponse;
            break;
        }
        if (expectedResponse != null) {
            OCSPUtils.verifyResponse(basicOcspResponse, issuerCertificate, responderCertificate, nounce.toByteArray(), date);
            return OCSPUtils.singleResponseToRevocationStatus(expectedResponse);
        }
        throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
    }

    private static boolean compareCertIDs(JcaCertificateID idLeft, CertificateID idRight) {
        if (idLeft == idRight) {
            return true;
        }
        if (idLeft == null || idRight == null) {
            return false;
        }
        return Arrays.equals(idLeft.getIssuerKeyHash(), idRight.getIssuerKeyHash()) && Arrays.equals(idLeft.getIssuerNameHash(), idRight.getIssuerNameHash()) && idLeft.getSerialNumber().equals(idRight.getSerialNumber());
    }

    private static void verifyResponse(BasicOCSPResp basicOcspResponse, X509Certificate issuerCertificate, X509Certificate responderCertificate, byte[] requestNonce, Date date) throws NoSuchProviderException, NoSuchAlgorithmException, CertificateNotYetValidException, CertificateExpiredException, CertPathValidatorException {
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(Arrays.asList(basicOcspResponse.getCerts()));
        Certificate signingCert = null;
        try {
            certs.add((X509CertificateHolder)new JcaX509CertificateHolder(issuerCertificate));
            if (responderCertificate != null) {
                certs.add((X509CertificateHolder)new JcaX509CertificateHolder(responderCertificate));
            }
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        if (certs.size() > 0) {
            X500Name responderName = basicOcspResponse.getResponderId().toASN1Primitive().getName();
            byte[] responderKey = basicOcspResponse.getResponderId().toASN1Primitive().getKeyHash();
            if (responderName != null) {
                logger.log(Level.INFO, "Responder Name: {0}", responderName.toString());
                for (X509CertificateHolder x509CertificateHolder : certs) {
                    try {
                        X509Certificate tempCert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
                        X500Name respName = new X500Name(tempCert.getSubjectX500Principal().getName());
                        if (!responderName.equals(respName)) continue;
                        signingCert = tempCert;
                        logger.log(Level.INFO, "Found a certificate whose principal \"{0}\" matches the responder name \"{1}\"", new Object[]{tempCert.getSubjectDN().getName(), responderName.toString()});
                        break;
                    }
                    catch (CertificateException e) {
                        logger.log(Level.FINE, e.getMessage());
                    }
                }
            } else if (responderKey != null) {
                SubjectKeyIdentifier responderSubjectKey = new SubjectKeyIdentifier(responderKey);
                logger.log(Level.INFO, "Responder Key: {0}", Arrays.toString(responderKey));
                for (X509CertificateHolder certHolder : certs) {
                    try {
                        X509Certificate tempCert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
                        SubjectKeyIdentifier subjectKeyIdentifier = null;
                        if (certHolder.getExtensions() != null) {
                            subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions(certHolder.getExtensions());
                        }
                        if (subjectKeyIdentifier != null) {
                            logger.log(Level.INFO, "Certificate: {0}\nSubject Key Id: {1}", new Object[]{tempCert.getSubjectDN().getName(), Arrays.toString(subjectKeyIdentifier.getKeyIdentifier())});
                        }
                        if (subjectKeyIdentifier != null && responderSubjectKey.equals(subjectKeyIdentifier)) {
                            signingCert = tempCert;
                            logger.log(Level.INFO, "Found a signer certificate \"{0}\" with the subject key extension value matching the responder key", ((X509Certificate)signingCert).getSubjectDN().getName());
                        } else {
                            subjectKeyIdentifier = new JcaX509ExtensionUtils().createSubjectKeyIdentifier(tempCert.getPublicKey());
                            if (!responderSubjectKey.equals(subjectKeyIdentifier)) continue;
                            signingCert = tempCert;
                            logger.log(Level.INFO, "Found a certificate \"{0}\" with the subject key matching the OCSP responder key", ((X509Certificate)signingCert).getSubjectDN().getName());
                        }
                        break;
                    }
                    catch (CertificateException e) {
                        logger.log(Level.FINE, e.getMessage());
                    }
                }
            }
        }
        if (signingCert != null) {
            if (signingCert.equals(issuerCertificate)) {
                logger.log(Level.INFO, "OCSP response is signed by the target's Issuing CA");
            } else if (responderCertificate != null && signingCert.equals(responderCertificate)) {
                logger.log(Level.INFO, "OCSP response is signed by an authorized responder certificate");
            } else {
                if (!((X509Certificate)signingCert).getIssuerX500Principal().equals(issuerCertificate.getSubjectX500Principal())) {
                    logger.log(Level.INFO, "Signer certificate's Issuer: {0}\nIssuer certificate's Subject: {1}", new Object[]{((X509Certificate)signingCert).getIssuerX500Principal().getName(), issuerCertificate.getSubjectX500Principal().getName()});
                    throw new CertPathValidatorException("Responder's certificate is not authorized to sign OCSP responses");
                }
                try {
                    List<String> purposes = ((X509Certificate)signingCert).getExtendedKeyUsage();
                    if (purposes != null && !purposes.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                        logger.log(Level.INFO, "OCSPSigning extended usage is not set");
                        throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                    }
                }
                catch (CertificateParsingException e) {
                    logger.log(Level.FINE, "Failed to get certificate's extended key usage extension\n{0}", e.getMessage());
                }
                if (date == null) {
                    ((X509Certificate)signingCert).checkValidity();
                } else {
                    ((X509Certificate)signingCert).checkValidity(date);
                }
                try {
                    Extension noOCSPCheck = new JcaX509CertificateHolder((X509Certificate)signingCert).getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck);
                    logger.log(Level.INFO, "OCSP no-check extension is {0} present", noOCSPCheck == null ? "not" : "");
                }
                catch (CertificateEncodingException e) {
                    logger.log(Level.FINE, "Certificate encoding exception: {0}", e.getMessage());
                }
                try {
                    signingCert.verify(issuerCertificate.getPublicKey());
                    logger.log(Level.INFO, "OCSP response is signed by an Authorized Responder");
                }
                catch (GeneralSecurityException ex) {
                    signingCert = null;
                }
            }
        }
        if (signingCert == null) {
            throw new CertPathValidatorException("Unable to verify OCSP Response's signature");
        }
        if (!OCSPUtils.verifySignature(basicOcspResponse, (X509Certificate)signingCert)) {
            throw new CertPathValidatorException("Error verifying OCSP Response's signature");
        }
        Extension responseNonce = basicOcspResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (responseNonce != null && requestNonce != null && !Arrays.equals(requestNonce, responseNonce.getExtnValue().getOctets())) {
            throw new CertPathValidatorException("Nonces do not match.");
        }
        long current = date == null ? System.currentTimeMillis() : date.getTime();
        Date date2 = new Date(current + 900000L);
        Date start = new Date(current - 900000L);
        Iterator<SingleResp> iter = Arrays.asList(basicOcspResponse.getResponses()).iterator();
        SingleResp singleRes = null;
        do {
            if (iter.hasNext()) continue;
            return;
        } while (!date2.before((singleRes = iter.next()).getThisUpdate()) && !start.after(singleRes.getNextUpdate() != null ? singleRes.getNextUpdate() : singleRes.getThisUpdate()));
        throw new CertPathValidatorException("Response is unreliable: its validity interval is out-of-date");
    }

    private static boolean verifySignature(BasicOCSPResp basicOcspResponse, X509Certificate cert) {
        try {
            ContentVerifierProvider contentVerifier = new JcaContentVerifierProviderBuilder().setProvider("BC").build(cert.getPublicKey());
            return basicOcspResponse.isSignatureValid(contentVerifier);
        }
        catch (OperatorCreationException e) {
            logger.log(Level.FINE, "Unable to construct OCSP content signature verifier\n{0}", e.getMessage());
        }
        catch (OCSPException e) {
            logger.log(Level.FINE, "Unable to validate OCSP response signature\n{0}", e.getMessage());
        }
        return false;
    }

    private static OCSPRevocationStatus unknownStatus() {
        return new OCSPRevocationStatus(){

            @Override
            public RevocationStatus getRevocationStatus() {
                return RevocationStatus.UNKNOWN;
            }

            @Override
            public Date getRevocationTime() {
                return new Date(System.currentTimeMillis());
            }

            @Override
            public CRLReason getRevocationReason() {
                return CRLReason.lookup(0);
            }
        };
    }

    private static OCSPRevocationStatus singleResponseToRevocationStatus(SingleResp singleResponse) throws CertPathValidatorException {
        CertificateStatus certStatus = singleResponse.getCertStatus();
        int revocationReason = 0;
        Date revocationTime = null;
        RevocationStatus status = RevocationStatus.UNKNOWN;
        if (certStatus == CertificateStatus.GOOD) {
            status = RevocationStatus.GOOD;
        } else if (certStatus instanceof RevokedStatus) {
            RevokedStatus revoked = (RevokedStatus)certStatus;
            revocationTime = revoked.getRevocationTime();
            status = RevocationStatus.REVOKED;
            if (revoked.hasRevocationReason()) {
                revocationReason = revoked.getRevocationReason();
            }
        } else if (certStatus instanceof UnknownStatus) {
            status = RevocationStatus.UNKNOWN;
        } else {
            throw new CertPathValidatorException("Unrecognized revocation status received from OCSP.");
        }
        final RevocationStatus finalStatus = status;
        final Date finalRevocationTime = revocationTime;
        final int finalRevocationReason = revocationReason;
        return new OCSPRevocationStatus(){

            @Override
            public RevocationStatus getRevocationStatus() {
                return finalStatus;
            }

            @Override
            public Date getRevocationTime() {
                return finalRevocationTime;
            }

            @Override
            public CRLReason getRevocationReason() {
                return CRLReason.lookup(finalRevocationReason);
            }
        };
    }

    private static List<String> getResponderURIs(X509Certificate cert) throws CertificateEncodingException {
        LinkedList<String> responderURIs = new LinkedList<String>();
        JcaX509CertificateHolder holder = new JcaX509CertificateHolder(cert);
        Extension aia = holder.getExtension(Extension.authorityInfoAccess);
        if (aia != null) {
            try {
                ASN1InputStream in = new ASN1InputStream(aia.getExtnValue().getOctetStream());
                ASN1Sequence seq = (ASN1Sequence)in.readObject();
                AuthorityInformationAccess authorityInfoAccess = AuthorityInformationAccess.getInstance(seq);
                for (AccessDescription ad : authorityInfoAccess.getAccessDescriptions()) {
                    if (!ad.getAccessMethod().equals(AccessDescription.id_ad_ocsp) || ad.getAccessLocation().getTagNo() != 6) continue;
                    DERIA5String value = DERIA5String.getInstance(ad.getAccessLocation().getName());
                    responderURIs.add(value.getString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responderURIs;
    }

    static {
        BouncyIntegration.init();
        logger = Logger.getLogger("" + OCSPUtils.class);
        OCSP_CONNECT_TIMEOUT = 10000;
    }

    public static interface OCSPRevocationStatus {
        public RevocationStatus getRevocationStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();
    }

    public static enum RevocationStatus {
        GOOD,
        REVOKED,
        UNKNOWN;

    }
}

