/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.parser.CommandLineCompletionParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.parser.ParsedCompleteObject;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.cl.validator.CommandValidatorException;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.AeshConsoleCallback;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.AeshInvocationProviders;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.InputProcessor;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.activator.AeshOptionActivatorProvider;
import org.jboss.aesh.console.command.activator.CommandActivatorProvider;
import org.jboss.aesh.console.command.activator.OptionActivatorProvider;
import org.jboss.aesh.console.command.completer.CompleterInvocationProvider;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerResult;
import org.jboss.aesh.console.command.converter.ConverterInvocationProvider;
import org.jboss.aesh.console.command.invocation.AeshCommandInvocation;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.console.command.invocation.CommandInvocationProvider;
import org.jboss.aesh.console.command.invocation.CommandInvocationServices;
import org.jboss.aesh.console.command.registry.AeshInternalCommandRegistry;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.console.command.validator.ValidatorInvocationProvider;
import org.jboss.aesh.console.export.ExportManager;
import org.jboss.aesh.console.helper.ManProvider;
import org.jboss.aesh.console.man.Man;
import org.jboss.aesh.console.settings.CommandNotFoundHandler;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.history.History;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.util.LoggerUtil;

public class AeshConsoleImpl
implements AeshConsole {
    private final Console console;
    private final CommandRegistry registry;
    private final CommandInvocationServices commandInvocationServices;
    private final InvocationProviders invocationProviders;
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshConsoleImpl.class.getName());
    private final ManProvider manProvider;
    private final CommandNotFoundHandler commandNotFoundHandler;
    private AeshInternalCommandRegistry internalRegistry;
    private String commandInvocationProvider = "default";

    AeshConsoleImpl(Settings settings, CommandRegistry registry, CommandInvocationServices commandInvocationServices, CommandNotFoundHandler commandNotFoundHandler, CompleterInvocationProvider completerInvocationProvider, ConverterInvocationProvider converterInvocationProvider, ValidatorInvocationProvider validatorInvocationProvider, OptionActivatorProvider optionActivatorProvider, ManProvider manProvider, CommandActivatorProvider commandActivatorProvider) {
        this.registry = registry;
        this.commandInvocationServices = commandInvocationServices;
        this.commandNotFoundHandler = commandNotFoundHandler;
        this.manProvider = manProvider;
        this.invocationProviders = new AeshInvocationProviders(converterInvocationProvider, completerInvocationProvider, validatorInvocationProvider, optionActivatorProvider, commandActivatorProvider);
        this.console = new Console(settings);
        this.console.setConsoleCallback(new AeshConsoleCallbackImpl(this));
        this.console.addCompletion(new AeshCompletion());
        this.processAfterInit(this.console.getSettings());
    }

    @Override
    public void start() {
        this.console.start();
    }

    @Override
    public void stop() {
        this.console.stop();
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.registry;
    }

    @Override
    public void setPrompt(Prompt prompt) {
        this.console.setPrompt(prompt);
    }

    @Override
    public Prompt getPrompt() {
        return this.console.getPrompt();
    }

    @Override
    public Shell getShell() {
        return this.console.getShell();
    }

    @Override
    public void clear() {
        try {
            this.console.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getHelpInfo(String commandName) {
        try (CommandContainer commandContainer = this.getCommand(commandName, "");){
            if (commandContainer == null) return "";
            String string = commandContainer.printHelp(commandName);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void setCurrentCommandInvocationProvider(String name) {
        this.commandInvocationProvider = name;
    }

    @Override
    public void registerCommandInvocationProvider(String name, CommandInvocationProvider commandInvocationProvider) {
        this.commandInvocationServices.registerProvider(name, commandInvocationProvider);
    }

    @Override
    public ManProvider getManProvider() {
        return this.manProvider;
    }

    @Override
    public AeshContext getAeshContext() {
        return this.console.getAeshContext();
    }

    @Override
    public boolean isRunning() {
        return this.console.isRunning();
    }

    @Override
    public boolean isEchoing() {
        return this.console.isEchoing();
    }

    @Override
    public void setEcho(boolean echo) {
        this.console.setEcho(echo);
    }

    @Override
    public ExportManager getExportManager() {
        return this.console.getExportManager();
    }

    public String getBuffer() {
        return this.console.getBuffer();
    }

    public InputProcessor getInputProcessor() {
        return this.console.getInputProcessor();
    }

    public void putProcessInBackground(int pid) {
        this.console.putProcessInBackground(pid);
    }

    public void putProcessInForeground(int pid) {
        this.console.putProcessInForeground(pid);
    }

    @Override
    public void execute(String input) {
        if (input.endsWith(Config.getLineSeparator())) {
            this.console.pushToInputStream(input);
        } else {
            this.console.pushToInputStream(input + Config.getLineSeparator());
        }
    }

    public void changeOutputStream(PrintStream output) {
        this.console.changeOutputStream(output);
    }

    private void processAfterInit(Settings settings) {
        block7: {
            if (settings.isManEnabled()) {
                this.internalRegistry = new AeshInternalCommandRegistry();
                this.internalRegistry.addCommand(new Man(this.manProvider));
            }
            try {
                for (String commandName : this.registry.getAllCommandNames()) {
                    ProcessedCommand cmd = this.registry.getCommand(commandName, "").getParser().getProcessedCommand();
                    List<CommandLineParser<?>> childParsers = this.registry.getChildCommandParsers(commandName);
                    if (!(this.invocationProviders.getOptionActivatorProvider() instanceof AeshOptionActivatorProvider)) {
                        cmd.updateInvocationProviders(this.invocationProviders);
                        for (CommandLineParser<?> child : childParsers) {
                            child.getProcessedCommand().updateInvocationProviders(this.invocationProviders);
                        }
                    }
                    if (settings.isAnsiConsole()) continue;
                    cmd.updateSettings(settings);
                    for (CommandLineParser<?> child : childParsers) {
                        child.getProcessedCommand().updateSettings(settings);
                    }
                }
            }
            catch (Exception e) {
                if (!this.console.getSettings().isLogging()) break block7;
                LOGGER.log(Level.WARNING, "Exception while iterating commands.", e);
            }
        }
    }

    private void completeCommandName(CompleteOperation co) {
        this.registry.completeCommandName(co);
        if (this.internalRegistry != null) {
            for (String internalCommand : this.internalRegistry.getAllCommandNames()) {
                if (!internalCommand.startsWith(co.getBuffer())) continue;
                co.addCompletionCandidate(internalCommand);
            }
        }
    }

    private CommandContainer getCommand(AeshLine aeshLine, String line) throws CommandNotFoundException {
        return this.getCommand(aeshLine.getWords().get(0), line);
    }

    private CommandContainer getCommand(String commandName, String line) throws CommandNotFoundException {
        try {
            return this.registry.getCommand(commandName, line);
        }
        catch (CommandNotFoundException e) {
            try {
                return this.registry.getCommandByAlias(commandName);
            }
            catch (CommandNotFoundException e2) {
                CommandContainer cc;
                if (this.internalRegistry != null && (cc = this.internalRegistry.getCommand(commandName)) != null) {
                    return cc;
                }
                throw e;
            }
        }
    }

    @Override
    public ConsoleCallback getConsoleCallback() {
        return this.console.getConsoleCallback();
    }

    public InvocationProviders getInvocationProviders() {
        return this.invocationProviders;
    }

    @Override
    public History getHistory() {
        return this.console.getHistory();
    }

    class AeshConsoleCallbackImpl
    extends AeshConsoleCallback {
        private final AeshConsoleImpl console;
        private CommandResult result;

        AeshConsoleCallbackImpl(AeshConsoleImpl aeshConsole) {
            this.console = aeshConsole;
        }

        @Override
        public int execute(ConsoleOperation output) throws InterruptedException {
            block29: {
                if (output != null && output.getBuffer().trim().length() > 0) {
                    ResultHandler resultHandler = null;
                    AeshLine aeshLine = Parser.findAllWords(output.getBuffer());
                    try (CommandContainer commandContainer = AeshConsoleImpl.this.getCommand(aeshLine, output.getBuffer());){
                        resultHandler = commandContainer.getParser().getProcessedCommand().getResultHandler();
                        CommandContainerResult ccResult = commandContainer.executeCommand(aeshLine, AeshConsoleImpl.this.invocationProviders, AeshConsoleImpl.this.getAeshContext(), (CommandInvocation)AeshConsoleImpl.this.commandInvocationServices.getCommandInvocationProvider(AeshConsoleImpl.this.commandInvocationProvider).enhanceCommandInvocation(new AeshCommandInvocation(this.console, output.getControlOperator(), output.getPid(), this)));
                        this.result = ccResult.getCommandResult();
                        if (this.result == CommandResult.SUCCESS && resultHandler != null) {
                            resultHandler.onSuccess();
                        } else if (resultHandler != null) {
                            resultHandler.onFailure(this.result);
                        }
                        break block29;
                    }
                    catch (CommandLineParserException | CommandValidatorException | OptionValidatorException e) {
                        AeshConsoleImpl.this.getShell().out().println(e.getMessage());
                        this.result = CommandResult.FAILURE;
                        if (resultHandler != null) {
                            resultHandler.onValidationFailure(this.result, e);
                        }
                        break block29;
                    }
                    catch (CommandNotFoundException cnfe) {
                        AeshConsoleImpl.this.getShell().out().println(cnfe.getMessage());
                        this.result = CommandResult.FAILURE;
                        if (AeshConsoleImpl.this.commandNotFoundHandler != null) {
                            AeshConsoleImpl.this.commandNotFoundHandler.handleCommandNotFound(output.getBuffer(), AeshConsoleImpl.this.getShell());
                        }
                        break block29;
                    }
                    catch (CommandException cmd) {
                        AeshConsoleImpl.this.getShell().out().println(cmd.getMessage());
                        this.result = CommandResult.FAILURE;
                        if (resultHandler != null) {
                            resultHandler.onExecutionFailure(this.result, cmd);
                        }
                        break block29;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (e instanceof InterruptedException) {
                            throw (InterruptedException)e;
                        }
                        LOGGER.log(Level.SEVERE, "Exception when parsing/running: " + output.getBuffer(), e);
                        AeshConsoleImpl.this.getShell().out().println("Exception when parsing/running: " + output.getBuffer() + ", " + e.getMessage());
                        this.result = CommandResult.FAILURE;
                        if (resultHandler != null) {
                            resultHandler.onValidationFailure(this.result, e);
                        }
                        break block29;
                    }
                }
                if (output != null) {
                    this.result = CommandResult.FAILURE;
                } else {
                    AeshConsoleImpl.this.stop();
                    this.result = CommandResult.FAILURE;
                }
            }
            if (this.result == CommandResult.SUCCESS) {
                return 0;
            }
            return 1;
        }
    }

    class AeshCompletion
    implements Completion {
        AeshCompletion() {
        }

        @Override
        public void complete(CompleteOperation completeOperation) {
            AeshConsoleImpl.this.completeCommandName(completeOperation);
            if (completeOperation.getCompletionCandidates().size() < 1) {
                AeshLine aeshLine = Parser.findAllWords(completeOperation.getBuffer());
                try (CommandContainer commandContainer = AeshConsoleImpl.this.getCommand(aeshLine, completeOperation.getBuffer());){
                    CommandLineCompletionParser completionParser = commandContainer.getParser().getCompletionParser();
                    ParsedCompleteObject completeObject = completionParser.findCompleteObject(completeOperation.getBuffer(), completeOperation.getCursor());
                    completeObject.getCompletionParser().injectValuesAndComplete(completeObject, completeOperation, AeshConsoleImpl.this.invocationProviders);
                }
                catch (CommandLineParserException e) {
                    LOGGER.warning(e.getMessage());
                }
                catch (CommandNotFoundException e) {
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Runtime exception when completing: " + completeOperation, ex);
                }
            }
        }
    }
}

