/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.completer;

import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.aesh.io.filter.AllResourceFilter;
import org.jboss.aesh.io.filter.ResourceFilter;
import org.jboss.aesh.util.FileLister;

public class FileOptionCompleter
implements OptionCompleter<CompleterInvocation> {
    private final ResourceFilter filter;

    public FileOptionCompleter() {
        this(new AllResourceFilter());
    }

    public FileOptionCompleter(ResourceFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("A valid filter must be informed");
        }
        this.filter = filter;
    }

    @Override
    public void complete(CompleterInvocation completerData) {
        CompleteOperation completeOperation = new CompleteOperation(completerData.getAeshContext(), completerData.getGivenCompleteValue(), 0);
        if (completerData.getGivenCompleteValue() == null) {
            new FileLister("", completerData.getAeshContext().getCurrentWorkingDirectory(), this.filter).findMatchingDirectories(completeOperation);
        } else {
            new FileLister(completerData.getGivenCompleteValue(), completerData.getAeshContext().getCurrentWorkingDirectory(), this.filter).findMatchingDirectories(completeOperation);
        }
        if (completeOperation.getCompletionCandidates().size() > 1) {
            completeOperation.removeEscapedSpacesFromCompletionCandidates();
        }
        completerData.setCompleterValuesTerminalString(completeOperation.getCompletionCandidates());
        if (completerData.getGivenCompleteValue() != null && completerData.getCompleterValues().size() == 1) {
            completerData.setAppendSpace(completeOperation.hasAppendSeparator());
        }
        if (completeOperation.doIgnoreOffset()) {
            completerData.setIgnoreOffset(completeOperation.doIgnoreOffset());
        }
        completerData.setIgnoreStartsWith(true);
    }

    public ResourceFilter getFilter() {
        return this.filter;
    }
}

