/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.AbstractDecisionCollector;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Permission;

public class DecisionPermissionCollector
extends AbstractDecisionCollector {
    private final AuthorizationProvider authorizationProvider;
    private final ResourceServer resourceServer;
    private final AuthorizationRequest request;
    private final Set<Permission> permissions = new LinkedHashSet<Permission>();

    public DecisionPermissionCollector(AuthorizationProvider authorizationProvider, ResourceServer resourceServer, AuthorizationRequest request) {
        this.authorizationProvider = authorizationProvider;
        this.resourceServer = resourceServer;
        this.request = request;
    }

    @Override
    public void onComplete(Result result) {
        ResourcePermission permission = result.getPermission();
        Resource resource = permission.getResource();
        Collection<Scope> requestedScopes = permission.getScopes();
        if (Decision.Effect.PERMIT.equals((Object)result.getEffect())) {
            if (permission.getScopes().isEmpty() && !resource.getScopes().isEmpty()) {
                return;
            }
            this.grantPermission(this.authorizationProvider, this.permissions, permission, requestedScopes, this.resourceServer, this.request, result);
        } else {
            HashSet<Scope> grantedScopes = new HashSet<Scope>();
            HashSet<Scope> deniedScopes = new HashSet<Scope>();
            ArrayList<Result.PolicyResult> userManagedPermissions = new ArrayList<Result.PolicyResult>();
            boolean resourceGranted = false;
            boolean anyDeny = false;
            for (Result.PolicyResult policyResult : result.getResults()) {
                Policy policy = policyResult.getPolicy();
                Set<Scope> policyScopes = policy.getScopes();
                Set<Resource> policyResources = policy.getResources();
                boolean containsResource = policyResources.contains(resource);
                if (this.isGranted(policyResult)) {
                    if (DecisionPermissionCollector.isScopePermission(policy)) {
                        for (Scope scope : requestedScopes) {
                            if (!policyScopes.contains(scope)) continue;
                            grantedScopes.add(scope);
                            if (resource == null || resource.getScopes().contains(scope)) continue;
                            deniedScopes.remove(scope);
                        }
                    } else if (DecisionPermissionCollector.isResourcePermission(policy)) {
                        grantedScopes.addAll(requestedScopes);
                    } else if (resource != null && resource.isOwnerManagedAccess() && "uma".equals(policy.getType())) {
                        userManagedPermissions.add(policyResult);
                    }
                    if (resourceGranted) continue;
                    resourceGranted = this.isGrantingAccessToResource(resource, policy) && containsResource;
                    continue;
                }
                if (DecisionPermissionCollector.isResourcePermission(policy)) {
                    if (containsResource || !resourceGranted) {
                        deniedScopes.addAll(requestedScopes);
                    }
                } else if (containsResource || policyResources.isEmpty()) {
                    deniedScopes.addAll(policyScopes);
                }
                if (anyDeny) continue;
                anyDeny = true;
            }
            if (DecisionStrategy.AFFIRMATIVE.equals(this.resourceServer.getDecisionStrategy())) {
                deniedScopes.removeAll(grantedScopes);
            }
            grantedScopes.removeAll(deniedScopes);
            if (userManagedPermissions.isEmpty()) {
                if (!resourceGranted && grantedScopes.isEmpty() && !requestedScopes.isEmpty()) {
                    return;
                }
            } else {
                for (Result.PolicyResult userManagedPermission : userManagedPermissions) {
                    HashSet<Scope> scopes = new HashSet<Scope>(userManagedPermission.getPolicy().getScopes());
                    if (!requestedScopes.isEmpty()) {
                        scopes.retainAll(requestedScopes);
                    }
                    grantedScopes.addAll(scopes);
                }
                if (grantedScopes.isEmpty() && !resource.getScopes().isEmpty()) {
                    return;
                }
                anyDeny = false;
            }
            if (anyDeny && grantedScopes.isEmpty()) {
                return;
            }
            this.grantPermission(this.authorizationProvider, this.permissions, permission, grantedScopes, this.resourceServer, this.request, result);
        }
    }

    private boolean isGrantingAccessToResource(Resource resource, Policy policy) {
        boolean scopePermission = DecisionPermissionCollector.isScopePermission(policy);
        if (!scopePermission) {
            return true;
        }
        return resource != null && !resource.getOwner().equals(this.resourceServer.getClientId());
    }

    public Collection<Permission> results() {
        return this.permissions;
    }

    @Override
    public void onError(Throwable cause) {
        throw new RuntimeException("Failed to evaluate permissions", cause);
    }

    protected void grantPermission(AuthorizationProvider authorizationProvider, Set<Permission> permissions, ResourcePermission permission, Collection<Scope> grantedScopes, ResourceServer resourceServer, AuthorizationRequest request, Result result) {
        Set<String> scopeNames = grantedScopes.stream().map(Scope::getName).collect(Collectors.toSet());
        Resource resource = permission.getResource();
        if (resource != null) {
            permissions.add(this.createPermission(resource, scopeNames, permission.getClaims(), request));
        } else if (!grantedScopes.isEmpty()) {
            ResourceStore resourceStore = authorizationProvider.getStoreFactory().getResourceStore();
            resourceStore.findByScopes(resourceServer, new HashSet<Scope>(grantedScopes), resource1 -> permissions.add(this.createPermission(resource, scopeNames, permission.getClaims(), request)));
            permissions.add(this.createPermission(null, scopeNames, permission.getClaims(), request));
        }
    }

    private Permission createPermission(Resource resource, Set<String> scopes, Map<String, Set<String>> claims, AuthorizationRequest request) {
        Permission permission;
        AuthorizationRequest.Metadata metadata = null;
        if (request != null) {
            metadata = request.getMetadata();
        }
        if (resource != null) {
            String resourceName = metadata == null || metadata.getIncludeResourceName() != false ? resource.getName() : null;
            permission = new Permission(resource.getId(), resourceName, scopes, claims);
        } else {
            permission = new Permission(null, null, scopes, claims);
        }
        this.onGrant(permission);
        return permission;
    }

    protected void onGrant(Permission permission) {
    }

    private static boolean isResourcePermission(Policy policy) {
        return "resource".equals(policy.getType());
    }

    private static boolean isScopePermission(Policy policy) {
        return "scope".equals(policy.getType());
    }
}

