/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.ConsoleBuffer;
import org.jboss.aesh.console.Prompt;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.PasteManager;
import org.jboss.aesh.edit.ViEditMode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.EditAction;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.undo.UndoAction;
import org.jboss.aesh.undo.UndoManager;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.LoggerUtil;

public class AeshConsoleBuffer
implements ConsoleBuffer {
    private EditMode editMode;
    private final PrintStream err;
    private PrintStream out;
    private final Buffer buffer;
    private final Shell shell;
    private final UndoManager undoManager;
    private final PasteManager pasteManager;
    private final boolean ansiMode;
    private Action currentAction = Action.EDIT;
    private final boolean isLogging = false;
    private boolean prompted = false;
    private static final char[] resetLineAndSetCursorToStart = (ANSI.CURSOR_SAVE + "\u001b[" + "0G" + "\u001b[" + "2K").toCharArray();
    private static final Logger LOGGER = LoggerUtil.getLogger(AeshConsoleBuffer.class.getName());

    AeshConsoleBuffer(Prompt prompt, Shell shell, EditMode editMode, boolean ansi) {
        this.out = shell.out();
        this.err = shell.err();
        this.ansiMode = ansi;
        this.buffer = new Buffer(this.ansiMode, prompt);
        this.shell = shell;
        this.pasteManager = new PasteManager();
        this.undoManager = new UndoManager();
        this.editMode = editMode;
        LOGGER.info("prompt: " + this.buffer.getPrompt().getPromptAsString());
    }

    @Override
    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public PrintStream out() {
        return this.out;
    }

    @Override
    public PrintStream err() {
        return this.err;
    }

    @Override
    public void changeOutputBuffer(PrintStream output) {
        this.out = output;
    }

    @Override
    public void setEditMode(EditMode editMode) {
        this.editMode = editMode;
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public PasteManager getPasteManager() {
        return this.pasteManager;
    }

    @Override
    public EditMode getEditMode() {
        return this.editMode;
    }

    @Override
    public void moveCursor(int where) {
        if (this.ansiMode) {
            if (this.editMode.getMode() == Mode.VI && (this.editMode.getCurrentAction() == Action.MOVE || this.editMode.getCurrentAction() == Action.DELETE)) {
                this.out.print(this.buffer.move(where, this.shell.getSize().getWidth(), true));
            } else {
                this.out.print(this.buffer.move(where, this.shell.getSize().getWidth()));
            }
            this.out.flush();
        }
    }

    @Override
    public void drawLine() {
        this.drawLine(true);
    }

    @Override
    public void drawLine(boolean keepCursorPosition) {
        String line = this.buffer.getPrompt().getPromptAsString() + this.buffer.getLine();
        if (!this.ansiMode) {
            this.out.print(Config.getLineSeparator());
            this.out.print(line);
            this.out.flush();
            return;
        }
        if (line.length() > this.shell.getSize().getWidth() || this.buffer.getDelta() < 0 && line.length() + Math.abs(this.buffer.getDelta()) > this.shell.getSize().getWidth()) {
            if (this.buffer.getDelta() == -1 && this.buffer.getCursor() >= this.buffer.length() && Config.isOSPOSIXCompatible()) {
                this.redrawMultipleLinesBackspace();
            } else {
                this.redrawMultipleLines(keepCursorPosition);
            }
        } else if (this.buffer.getDelta() == -1 && this.buffer.getCursor() >= this.buffer.length() && this.currentAction != Action.HISTORY && !this.isEndOfLine()) {
            this.out.print(" \u001b[1D");
        } else {
            if (keepCursorPosition) {
                this.out.print(resetLineAndSetCursorToStart);
            }
            this.out.print("\u001b[0G\u001b[2K");
            if (!this.buffer.isPromptDisabled()) {
                this.displayPrompt();
            }
            if (keepCursorPosition) {
                this.out.print(this.buffer.getLine() + ANSI.CURSOR_RESTORE);
            } else {
                this.out.print(this.buffer.getLine());
                this.buffer.setCursor(this.buffer.getLine().length());
            }
        }
        this.out.flush();
    }

    private boolean isEndOfLine() {
        return this.buffer.getCursorWithPrompt() == this.shell.getSize().getWidth();
    }

    @Override
    public void updateCurrentAction(Action action) {
        this.currentAction = action;
    }

    private void redrawMultipleLines(boolean keepCursorPosition) {
        int currentRow = 0;
        if (this.buffer.getCursorWithPrompt() > 0) {
            currentRow = this.buffer.getCursorWithPrompt() / this.shell.getSize().getWidth();
        }
        if (currentRow > 0 && this.buffer.getCursorWithPrompt() % this.shell.getSize().getWidth() == 0) {
            --currentRow;
        }
        StringBuilder builder = new StringBuilder();
        if (keepCursorPosition) {
            builder.append(ANSI.CURSOR_SAVE);
        }
        if (this.buffer.getDelta() > 0) {
            if (currentRow > 0) {
                for (int i = 0; i < currentRow; ++i) {
                    builder.append(Buffer.printAnsi("A"));
                }
            }
        } else {
            this.clearDelta(currentRow, builder);
        }
        builder.append(Buffer.printAnsi("0G"));
        if (!this.buffer.isPromptDisabled()) {
            if (this.buffer.getPrompt().hasANSI()) {
                builder.append(this.buffer.getPrompt().getANSI());
            } else {
                builder.append(this.buffer.getPrompt().getPromptAsString());
            }
        }
        builder.append(this.buffer.getLine());
        if (this.buffer.getDelta() < 0) {
            builder.append(Buffer.printAnsi("K"));
        }
        if (keepCursorPosition) {
            builder.append(ANSI.CURSOR_RESTORE);
            this.out.print(builder.toString());
        } else {
            this.out.print(builder.toString());
            this.buffer.setCursor(this.buffer.getLine().length());
        }
    }

    private void clearDelta(int currentRow, StringBuilder builder) {
        if (this.buffer.getDelta() < 0) {
            int tmpCurrentRow;
            int currentLength = this.buffer.getLineWithPrompt().length();
            int numberOfCurrentRows = currentLength / this.shell.getSize().getWidth();
            int numberOfPrevRows = (currentLength + this.buffer.getDelta() * -1) / this.shell.getSize().getWidth();
            int numberOfRowsToRemove = numberOfPrevRows - numberOfCurrentRows;
            int numberofRows = (this.buffer.getDelta() * -1 + this.buffer.getLineWithPrompt().length()) / this.shell.getSize().getWidth();
            if (numberOfRowsToRemove == 0) {
                ++numberOfRowsToRemove;
            }
            for (tmpCurrentRow = currentRow; tmpCurrentRow < numberofRows; ++tmpCurrentRow) {
                builder.append(Buffer.printAnsi("B"));
            }
            while (tmpCurrentRow > 0) {
                if (numberOfRowsToRemove > 0) {
                    builder.append(Buffer.printAnsi("2K"));
                    --numberOfRowsToRemove;
                }
                builder.append(Buffer.printAnsi("A"));
                --tmpCurrentRow;
            }
        }
    }

    private void redrawMultipleLinesBackspace() {
        this.out.print(" \u001b[1D");
    }

    @Override
    public void syncCursor() {
        if (this.buffer.getCursor() != this.buffer.getLine().length() && this.ansiMode) {
            this.out.print(Buffer.printAnsi(Math.abs(this.buffer.getCursor() - this.buffer.getLine().length()) + "D"));
            this.out.flush();
        }
    }

    @Override
    public void replace(int rChar) {
        this.addActionToUndoStack();
        this.buffer.replaceChar((char)rChar);
        this.drawLine();
    }

    @Override
    public void changeCase() {
        if (this.buffer.changeCase()) {
            this.moveCursor(1);
            this.drawLine();
        }
    }

    @Override
    public void capitalizeWord() {
        String word = Parser.findWordClosestToCursor(this.buffer.getLineNoMask(), this.buffer.getCursor());
        if (word.length() > 0) {
            int pos = this.buffer.getLineNoMask().indexOf(word, this.buffer.getCursor() - word.length());
            if (pos < 0) {
                pos = 0;
            }
            this.buffer.replaceChar(Character.toUpperCase(this.buffer.getLineNoMask().charAt(pos)), pos);
            this.drawLine();
        }
    }

    @Override
    public void lowerCaseWord() {
        String word = Parser.findWordClosestToCursor(this.buffer.getLineNoMask(), this.buffer.getCursor());
        if (word.length() > 0) {
            int pos = this.buffer.getLineNoMask().indexOf(word, this.buffer.getCursor() - word.length());
            if (pos < 0) {
                pos = 0;
            }
            for (int i = 0; i < word.length(); ++i) {
                this.buffer.replaceChar(Character.toLowerCase(this.buffer.getLineNoMask().charAt(pos + i)), pos + i);
            }
            this.drawLine();
        }
    }

    @Override
    public void upperCaseWord() {
        String word = Parser.findWordClosestToCursor(this.buffer.getLineNoMask(), this.buffer.getCursor());
        if (word.length() > 0) {
            int pos = this.buffer.getLineNoMask().indexOf(word, this.buffer.getCursor() - word.length());
            if (pos < 0) {
                pos = 0;
            }
            for (int i = 0; i < word.length(); ++i) {
                this.buffer.replaceChar(Character.toUpperCase(this.buffer.getLineNoMask().charAt(pos + i)), pos + i);
            }
            this.drawLine();
        }
    }

    @Override
    public void writeChars(int[] chars) {
        for (int c : chars) {
            this.writeChar((char)c);
        }
    }

    @Override
    public void writeString(String input) {
        for (char c : input.toCharArray()) {
            this.writeChar(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeChar(char c) {
        this.buffer.write(c);
        if (this.buffer.getPrompt().isMasking()) {
            if (this.buffer.getPrompt().getMask().charValue() == '\u0000') return;
            this.out.print(this.buffer.getPrompt().getMask());
        } else {
            if (!this.buffer.isEchoing()) {
                return;
            }
            this.out.print(c);
        }
        if (this.buffer.getCursorWithPrompt() > this.shell.getSize().getWidth() && this.buffer.getCursorWithPrompt() % this.shell.getSize().getWidth() == 1) {
            this.out.print(' ');
            this.out.print('\r');
        }
        if (!this.ansiMode) {
            this.out.flush();
            return;
        }
        if (this.buffer.getCursor() < this.buffer.length()) {
            if (this.buffer.totalLength() > this.shell.getSize().getWidth() && (this.buffer.totalLength() - 1) % this.shell.getSize().getWidth() == 1) {
                int totalRows;
                int ansiCurrentRow = this.shell.getCursor().getRow();
                int currentRow = this.buffer.getCursorWithPrompt() / this.shell.getSize().getWidth();
                if (currentRow > 0 && this.buffer.getCursorWithPrompt() % this.shell.getSize().getWidth() == 0) {
                    --currentRow;
                }
                if ((totalRows = this.buffer.totalLength() / this.shell.getSize().getWidth()) > 0 && this.buffer.totalLength() % this.shell.getSize().getWidth() == 0) {
                    --totalRows;
                }
                if (ansiCurrentRow + (totalRows - currentRow) > this.shell.getSize().getHeight() && this.ansiMode) {
                    this.out.print(Buffer.printAnsi("1S"));
                    this.out.print(Buffer.printAnsi("1A"));
                }
            }
            this.drawLine();
        }
        this.out.flush();
    }

    @Override
    public void displayPrompt() {
        this.displayPrompt(this.buffer.getPrompt());
    }

    @Override
    public void setPrompt(Prompt prompt) {
        this.buffer.updatePrompt(prompt);
    }

    @Override
    public void updatePrompt(Prompt prompt) {
        if (!this.buffer.getPrompt().equals(prompt)) {
            this.buffer.updatePrompt(prompt);
            if (this.ansiMode) {
                this.out.print("\u001b[0G\u001b[2K");
                this.displayPrompt(prompt);
                if (this.buffer.getLine().length() > 0) {
                    this.out().print(this.buffer.getLine());
                    this.buffer.setCursor(this.buffer.getLine().length());
                    this.out().flush();
                }
                this.prompted = true;
            }
        }
    }

    @Override
    public void setBufferLine(String newLine) {
        int currentRow;
        if (newLine.length() + this.buffer.getPrompt().getLength() >= this.shell.getSize().getWidth() && newLine.length() >= this.buffer.getLine().length() && (currentRow = this.shell.getCursor().getRow()) > -1) {
            int cursorRow = this.buffer.getCursorWithPrompt() / this.shell.getSize().getWidth();
            if (currentRow + newLine.length() / this.shell.getSize().getWidth() - cursorRow >= this.shell.getSize().getHeight()) {
                int numNewRows = currentRow + (newLine.length() + this.buffer.getPrompt().getLength()) / this.shell.getSize().getWidth() - cursorRow - this.shell.getSize().getHeight();
                if ((newLine.length() + this.buffer.getPrompt().getLength()) % this.shell.getSize().getWidth() == 0) {
                    ++numNewRows;
                }
                if (numNewRows > 0) {
                    this.out.print(Buffer.printAnsi(numNewRows + "S"));
                    this.out.print(Buffer.printAnsi(numNewRows + "A"));
                    this.out.flush();
                }
            }
        }
        this.buffer.setLine(newLine);
    }

    @Override
    public void insertBufferLine(String insert, int position) {
        int currentRow;
        if (insert.length() + this.buffer.totalLength() >= this.shell.getSize().getWidth() && (currentRow = this.shell.getCursor().getRow()) > -1) {
            int newLine = insert.length() + this.buffer.totalLength();
            int cursorRow = this.buffer.getCursorWithPrompt() / this.shell.getSize().getWidth();
            if (currentRow + newLine / this.shell.getSize().getWidth() - cursorRow >= this.shell.getSize().getHeight()) {
                int numNewRows = currentRow + newLine / this.shell.getSize().getWidth() - cursorRow - this.shell.getSize().getHeight();
                if ((insert.length() + this.buffer.totalLength()) % this.shell.getSize().getWidth() == 0) {
                    ++numNewRows;
                }
                if (numNewRows > 0) {
                    this.out.print(Buffer.printAnsi(numNewRows + "S"));
                    this.out.print(Buffer.printAnsi(numNewRows + "A"));
                    this.out.flush();
                }
            }
        }
        this.buffer.insert(position, insert);
    }

    private void displayPrompt(Prompt prompt) {
        if (prompt.hasANSI() && this.ansiMode) {
            this.out.print(prompt.getANSI());
        } else {
            this.out.print(prompt.getPromptAsString());
        }
        this.out.flush();
    }

    @Override
    public boolean performAction(EditAction action) throws IOException {
        this.currentAction = action.getAction();
        action.doAction(this.buffer.getLine());
        if (action.getAction() == Action.MOVE) {
            this.moveCursor(action.getEnd() - action.getStart());
            return true;
        }
        if (action.getAction() == Action.DELETE || action.getAction() == Action.CHANGE) {
            this.addActionToUndoStack();
            if (action.getEnd() > action.getStart()) {
                if (action.getStart() != this.buffer.getCursor()) {
                    this.moveCursor(action.getStart() - this.buffer.getCursor());
                }
                this.addToPaste(this.buffer.getLine().substring(action.getStart(), action.getEnd()));
                this.buffer.delete(action.getStart(), action.getEnd());
            } else {
                this.addToPaste(this.buffer.getLine().substring(action.getEnd(), action.getStart()));
                this.buffer.delete(action.getEnd(), action.getStart());
                this.moveCursor(action.getEnd() - action.getStart());
            }
            if (this.editMode.getMode() == Mode.VI && this.buffer.getCursor() == this.buffer.length() && !((ViEditMode)this.editMode).isInEditMode()) {
                this.moveCursor(-1);
            }
            this.drawLine();
        } else if (action.getAction() == Action.YANK) {
            if (action.getEnd() > action.getStart()) {
                this.addToPaste(this.buffer.getLine().substring(action.getStart(), action.getEnd()));
            } else {
                this.addToPaste(this.buffer.getLine().substring(action.getEnd(), action.getStart()));
            }
        }
        return true;
    }

    @Override
    public boolean paste(int index, boolean before) {
        StringBuilder pasteBuffer = this.pasteManager.get(index);
        if (pasteBuffer == null) {
            return false;
        }
        this.addActionToUndoStack();
        if (before || this.buffer.getCursor() >= this.buffer.getLine().length()) {
            this.insertBufferLine(pasteBuffer.toString(), this.buffer.getCursor());
            this.drawLine();
        } else {
            this.insertBufferLine(pasteBuffer.toString(), this.buffer.getCursor() + 1);
            this.drawLine();
            this.moveCursor(1);
        }
        return true;
    }

    @Override
    public void addActionToUndoStack() {
        UndoAction ua = new UndoAction(this.buffer.getCursor(), this.buffer.getLine());
        this.undoManager.addUndo(ua);
    }

    private void addToPaste(String buffer) {
        this.pasteManager.addText(new StringBuilder(buffer));
    }

    @Override
    public void clear(boolean includeBuffer) {
        if (this.ansiMode) {
            if (!Config.isOSPOSIXCompatible()) {
                this.out().print(Config.getLineSeparator());
            }
            this.out().print(ANSI.CLEAR_SCREEN);
            this.out().print(Buffer.printAnsi("1;1H"));
            if (includeBuffer) {
                this.displayPrompt();
                this.out().print(this.buffer.getLine());
            }
            this.out().flush();
        }
    }

    @Override
    public boolean isPrompted() {
        return this.prompted;
    }

    @Override
    public void setPrompted(boolean prompted) {
        this.prompted = prompted;
    }
}

