/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwe;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JWEHeader
implements Serializable {
    @JsonProperty(value="alg")
    private String algorithm;
    @JsonProperty(value="enc")
    private String encryptionAlgorithm;
    @JsonProperty(value="zip")
    private String compressionAlgorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    @JsonProperty(value="kid")
    private String keyId;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWEHeader() {
    }

    public JWEHeader(String algorithm, String encryptionAlgorithm, String compressionAlgorithm) {
        this.algorithm = algorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String toString() {
        try {
            return mapper.writeValueAsString(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

