/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authentication;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.authentication.ClientCredentialsProvider;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.representations.JsonWebToken;

public class JWTClientCredentialsProvider
implements ClientCredentialsProvider {
    public static final String PROVIDER_ID = "jwt";
    private KeyPair keyPair;
    private JWK publicKeyJwk;
    private int tokenTimeout;

    @Override
    public String getId() {
        return PROVIDER_ID;
    }

    public void setupKeyPair(KeyPair keyPair) {
        this.keyPair = keyPair;
        this.publicKeyJwk = JWKBuilder.create().rs256(keyPair.getPublic());
    }

    public void setTokenTimeout(int tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    protected int getTokenTimeout() {
        return this.tokenTimeout;
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    @Override
    public void init(KeycloakDeployment deployment, Object config) {
        String clientKeyAlias;
        if (config == null || !(config instanceof Map)) {
            throw new RuntimeException("Configuration of jwt credentials is missing or incorrect for client '" + deployment.getResourceName() + "'. Check your adapter configuration");
        }
        Map cfg = (Map)config;
        String clientKeystoreFile = (String)cfg.get("client-keystore-file");
        if (clientKeystoreFile == null) {
            throw new RuntimeException("Missing parameter client-keystore-file in configuration of jwt for client " + deployment.getResourceName());
        }
        String clientKeystoreType = (String)cfg.get("client-keystore-type");
        KeystoreUtil.KeystoreFormat clientKeystoreFormat = clientKeystoreType == null ? KeystoreUtil.KeystoreFormat.JKS : Enum.valueOf(KeystoreUtil.KeystoreFormat.class, clientKeystoreType.toUpperCase());
        String clientKeystorePassword = (String)cfg.get("client-keystore-password");
        if (clientKeystorePassword == null) {
            throw new RuntimeException("Missing parameter client-keystore-password in configuration of jwt for client " + deployment.getResourceName());
        }
        String clientKeyPassword = (String)cfg.get("client-key-password");
        if (clientKeyPassword == null) {
            clientKeyPassword = clientKeystorePassword;
        }
        if ((clientKeyAlias = (String)cfg.get("client-key-alias")) == null) {
            clientKeyAlias = deployment.getResourceName();
        }
        KeyPair keyPair = KeystoreUtil.loadKeyPairFromKeystore(clientKeystoreFile, clientKeystorePassword, clientKeyPassword, clientKeyAlias, clientKeystoreFormat);
        this.setupKeyPair(keyPair);
        this.tokenTimeout = this.asInt(cfg, "token-timeout", 10);
    }

    private Integer asInt(Map<String, Object> cfg, String cfgKey, int defaultValue) {
        Object cfgObj = cfg.get(cfgKey);
        if (cfgObj == null) {
            return defaultValue;
        }
        if (cfgObj instanceof String) {
            return Integer.parseInt(cfgObj.toString());
        }
        if (cfgObj instanceof Number) {
            return ((Number)cfgObj).intValue();
        }
        throw new IllegalArgumentException("Can't parse " + cfgKey + " from the config. Value is " + cfgObj);
    }

    @Override
    public void setClientCredentials(KeycloakDeployment deployment, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String signedToken = this.createSignedRequestToken(deployment.getResourceName(), deployment.getRealmInfoUrl());
        formParams.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        formParams.put("client_assertion", signedToken);
    }

    public String createSignedRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken jwt = this.createRequestToken(clientId, realmInfoUrl);
        return new JWSBuilder().kid(this.publicKeyJwk.getKeyId()).jsonContent(jwt).rsa256(this.keyPair.getPrivate());
    }

    protected JsonWebToken createRequestToken(String clientId, String realmInfoUrl) {
        JsonWebToken reqToken = new JsonWebToken();
        reqToken.id(AdapterUtils.generateId());
        reqToken.issuer(clientId);
        reqToken.subject(clientId);
        reqToken.audience(realmInfoUrl);
        int now = Time.currentTime();
        reqToken.issuedAt(now);
        reqToken.expiration(now + this.tokenTimeout);
        reqToken.notBefore(now);
        return reqToken;
    }
}

