/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client;

import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.keycloak.admin.client.Config;
import org.keycloak.admin.client.resource.BearerAuthFilter;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RealmsResource;
import org.keycloak.admin.client.token.TokenManager;

public class Keycloak {
    private final Config config;
    private final TokenManager tokenManager;
    private final ResteasyWebTarget target;
    private final ResteasyClient client;

    private Keycloak(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        this.config = new Config(serverUrl, realm, username, password, clientId, clientSecret);
        this.tokenManager = new TokenManager(this.config);
        this.client = new ResteasyClientBuilder().build();
        this.target = this.client.target(this.config.getServerUrl());
        this.target.register((Object)new BearerAuthFilter(this.tokenManager.getAccessTokenString()));
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId, String clientSecret) {
        return new Keycloak(serverUrl, realm, username, password, clientId, clientSecret);
    }

    public static Keycloak getInstance(String serverUrl, String realm, String username, String password, String clientId) {
        return new Keycloak(serverUrl, realm, username, password, clientId, null);
    }

    public RealmsResource realms() {
        return (RealmsResource)this.target.proxy(RealmsResource.class);
    }

    public RealmResource realm(String realmName) {
        return this.realms().realm(realmName);
    }

    public TokenManager tokenManager() {
        return this.tokenManager;
    }

    public void close() {
        this.client.close();
    }
}

