/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.keycloak.common.util.BouncyIntegration;

public final class CRLUtils {
    private static final String CRL_DISTRIBUTION_POINTS_OID = "2.5.29.31";

    public static List<String> getCRLDistributionPoints(X509Certificate cert) throws IOException {
        CRLDistPoint crlDP;
        DEROctetString octetString;
        byte[] data = cert.getExtensionValue(CRL_DISTRIBUTION_POINTS_OID);
        if (data == null) {
            return Collections.emptyList();
        }
        LinkedList<String> distributionPointUrls = new LinkedList<String>();
        try (ASN1InputStream crldpExtensionInputStream = new ASN1InputStream(new ByteArrayInputStream(data));){
            octetString = (DEROctetString)crldpExtensionInputStream.readObject();
        }
        byte[] octets = octetString.getOctets();
        try (ASN1InputStream crldpInputStream = new ASN1InputStream(new ByteArrayInputStream(octets));){
            crlDP = CRLDistPoint.getInstance(crldpInputStream.readObject());
        }
        for (DistributionPoint dp : crlDP.getDistributionPoints()) {
            GeneralName[] names;
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            for (GeneralName gn : names = GeneralNames.getInstance(dpn.getName()).getNames()) {
                if (gn.getTagNo() != 6) continue;
                String url = DERIA5String.getInstance(gn.getName()).getString();
                distributionPointUrls.add(url);
            }
        }
        return distributionPointUrls;
    }

    static {
        BouncyIntegration.init();
    }
}

